for confdir in /etc; do 
		find $ROOT/$confdir -name '*.new' | while read i; do 
			BASE=$(dirname $i)/$(basename $i .new) 
			echo Verificando $BASE 
			if [ -f $BASE ]; then 
				rm -f $i 
			else 
				mv -v $i $BASE 
			fi 
		done; 
done
# Fix a previous package version that included
# the /etc/rc.d/rc.local file without the .new file name extension

# Remember that upgradepkg performs the upgrade in three stages:
# 1) Pre-install the new package
# 2) Remove the old package
# 3) Install the new package again

rclocal=$ROOT/etc/rc.d/rc.local
bakext=rc-scripts-iztaci-1.6.0-i686-1.bak
# This will save the file when upgradepkg pre-installs the new package
if [ -f "$rclocal" ]; then
   [ -f "${rclocal}.$bakext" ] || cp -v "$rclocal" "${rclocal}.$bakext"
fi 

# This will restore it after the old package has been deleted
# and upgradepkg installs the new package again
[ -f "${rclocal}.$bakext" ] && cp -v "${rclocal}.$bakext" "$rclocal"
( cd etc/rc.d ; rm -rf rc.6 )
( cd etc/rc.d ; ln -sf /etc/rc.d/rc.0 rc.6 )
