for confdir in /etc; do 
		find $ROOT/$confdir -name '*.new' | while read i; do 
			BASE=$(dirname $i)/$(basename $i .new) 
			echo Verificando $BASE 
			if [ -f $BASE ]; then 
				rm -f $i 
			else 
				mv -v $i $BASE 
			fi 
		done; 
done
if ! grep -q ^mysql: /etc/group ; then
   echo Agregando grupo mysql
   groupadd -g 60 mysql
fi

if ! grep -q ^mysql: /etc/passwd ; then
   echo Agregando usuario mysql
   useradd -d /usr/local/mysql -s /bin/false mysql -u 60 -g mysql -m -k /dev/null
fi

if ! [ -d /usr/local/mysql/data ]; then
   echo
   echo Creando directorio de base de datos /usr/local/mysql/data...
   mkdir -p /usr/local/mysql/data

   echo
   echo Poniendo permisos...
   chown -R mysql:mysql /usr/local/mysql/data

   echo
   echo Inicializando base de datos...
   mysql_install_db --datadir=/usr/local/mysql/data --user=mysql
fi

( cd usr/lib ; rm -rf libmysqlclient_r.a )
( cd usr/lib ; ln -sf libmysqlclient.a libmysqlclient_r.a )
( cd usr/lib ; rm -rf libmysqlclient_r.so.18.1.0 )
( cd usr/lib ; ln -sf libmysqlclient.so.18.1.0 libmysqlclient_r.so.18.1.0 )
( cd usr/lib ; rm -rf libmysqlclient_r.so.18 )
( cd usr/lib ; ln -sf libmysqlclient.so.18 libmysqlclient_r.so.18 )
( cd usr/lib ; rm -rf libmysqlclient.so )
( cd usr/lib ; ln -sf libmysqlclient.so.18 libmysqlclient.so )
( cd usr/lib ; rm -rf libmysqlclient.so.18 )
( cd usr/lib ; ln -sf libmysqlclient.so.18.1.0 libmysqlclient.so.18 )
( cd usr/lib ; rm -rf libmysqlclient_r.so )
( cd usr/lib ; ln -sf libmysqlclient.so libmysqlclient_r.so )
