for confdir in /etc; do 
		find $ROOT/$confdir -name '*.new' | while read i; do 
			BASE=$(dirname $i)/$(basename $i .new) 
			echo Verificando $BASE 
			if [ -f $BASE ]; then 
				rm -f $i 
			else 
				mv -v $i $BASE 
			fi 
		done; 
done
if ! egrep -q ^postgres: etc/group; then
  echo Agregando grupo postgres, GID=55
  groupadd -g 55 postgres
fi

if ! egrep -q ^postgres: etc/passwd; then
  echo Agregando usuario postgres, UID=55
  useradd -s /bin/bash -d /home/postgres -u 55 -g postgres -k /dev/null -m postgres
fi

if ! [ -d /usr/local/pgsql/data ]; then
   echo
   echo "Creando directorio de base de datos /usr/local/pgsql/data..."
   mkdir -p /usr/local/pgsql/data

   echo
   echo "Poniendo permisos..."
   chown postgres /usr/local/pgsql/data

   echo
   echo Inicializando base de datos...
   su - postgres -c "/usr/bin/initdb -D /usr/local/pgsql/data"
fi


( cd usr/bin ; rm -rf postmaster )
( cd usr/bin ; ln -sf postgres postmaster )
( cd usr/lib ; rm -rf libpgtypes.so )
( cd usr/lib ; ln -sf libpgtypes.so.3.4 libpgtypes.so )
( cd usr/lib ; rm -rf libecpg_compat.so.3 )
( cd usr/lib ; ln -sf libecpg_compat.so.3.5 libecpg_compat.so.3 )
( cd usr/lib ; rm -rf libpq.so.5 )
( cd usr/lib ; ln -sf libpq.so.5.6 libpq.so.5 )
( cd usr/lib ; rm -rf libecpg_compat.so )
( cd usr/lib ; ln -sf libecpg_compat.so.3.5 libecpg_compat.so )
( cd usr/lib ; rm -rf libecpg.so.6 )
( cd usr/lib ; ln -sf libecpg.so.6.5 libecpg.so.6 )
( cd usr/lib ; rm -rf libpq.so )
( cd usr/lib ; ln -sf libpq.so.5.6 libpq.so )
( cd usr/lib ; rm -rf libecpg.so )
( cd usr/lib ; ln -sf libecpg.so.6.5 libecpg.so )
( cd usr/lib ; rm -rf libpgtypes.so.3 )
( cd usr/lib ; ln -sf libpgtypes.so.3.4 libpgtypes.so.3 )
