/* ISC license. */

#ifndef SKALIBS_POSIXPLZ_H
#define SKALIBS_POSIXPLZ_H

#include <sys/types.h>
#include <sys/stat.h>

#include <skalibs/gccattributes.h>
#include <skalibs/functypes.h>


 /*
    Stuff that doesn't have its own POSIX header for some reason.
 */

extern char **environ ;


 /*
    Non-POSIX functions that some OSes provide and others don't.
    setgroups() isn't included because it's its own kind of broken.
 */

extern void *memmem (void const *, size_t, void const *, size_t) gccattr_pure ;
extern int getpeereid (int, uid_t *, gid_t *) ;


 /*
    Functions that aren't standard at all, but honestly could be. :P
 */

extern void execvep (char const *, char const *const *, char const *const *, char const *) ;
extern void execvep_loose (char const *, char const *const *, char const *const *, char const *) ;
extern void unlink_void (char const *) ;
extern pid_t doublefork (void) ;
extern int touch (char const *) ;

extern int mkfiletemp (char *, createfunc_t_ref, mode_t, void *) ;
extern int mklinktemp (char const *, char *, linkfunc_t_ref) ;
extern int mkptemp (char *) ;
extern int mkltemp (char const *, char *) ;
extern int mkhtemp (char const *, char *) ;
extern int mkctemp (char *, mode_t, dev_t) ;
extern int mkbtemp (char *, mode_t, dev_t) ;

#endif
