for confdir in /etc; do 
		find $ROOT/$confdir -name '*.new' | while read i; do 
			BASE=$(dirname $i)/$(basename $i .new) 
			echo Verificando $BASE 
			if [ -f $BASE ]; then 
				rm -f $i 
			else 
				mv -v $i $BASE 
			fi 
		done; 
done

# Fix a previous package version that included
# the /etc/sysconfig/dhcpd file without the .new file name extension

# Remember that upgradepkg performs the upgrade in three stages:
# 1) Pre-install the new package
# 2) Remove the old package
# 3) Install the new package again

sc_dhcpd=$ROOT/etc/sysconfig/dhcpd
bakext=dhcp-4.3.6-P1-i686-1.bak
# This will save the file when upgradepkg pre-installs the new package
if [ -f "$sc_dhcpd" ]; then
   [ -f "${sc_dhcpd}.$bakext" ] || cp -v "$sc_dhcpd" "${sc_dhcpd}.$bakext"
fi 

# This will restore it after the old package has been deleted
# and upgradepkg installs the new package again
[ -f "${sc_dhcpd}.$bakext" ] && cp -v "${sc_dhcpd}.$bakext" "$sc_dhcpd"

# Create the leases file if it doesn't exist
touch /var/db/dhcpd.leases

for confdir in /etc; do 
		find $ROOT/$confdir -name '*.new' | while read i; do 
			BASE=$(dirname $i)/$(basename $i .new) 
			echo Verificando $BASE 
			if [ -f $BASE ]; then 
				rm -f $i 
			else 
				mv -v $i $BASE 
			fi 
		done; 
done

# Fix a previous package version that included
# the /etc/sysconfig/dhcpd file without the .new file name extension

# Remember that upgradepkg performs the upgrade in three stages:
# 1) Pre-install the new package
# 2) Remove the old package
# 3) Install the new package again

sc_dhcpd=$ROOT/etc/sysconfig/dhcpd
bakext=dhcp-4.3.6-P1-i686-1.bak
# This will save the file when upgradepkg pre-installs the new package
if [ -f "$sc_dhcpd" ]; then
   [ -f "${sc_dhcpd}.$bakext" ] || cp -v "$sc_dhcpd" "${sc_dhcpd}.$bakext"
fi 

# This will restore it after the old package has been deleted
# and upgradepkg installs the new package again
[ -f "${sc_dhcpd}.$bakext" ] && cp -v "${sc_dhcpd}.$bakext" "$sc_dhcpd"

# Create the leases file if it doesn't exist
touch /var/db/dhcpd.leases

