<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Chiffrement SSL/TLS fort :  Introduction - Serveur Apache HTTP Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">SSL/TLS</a></div><div id="page-content"><div id="preamble"><h1>Chiffrement SSL/TLS fort :  Introduction</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/ssl/ssl_intro.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/ssl/ssl_intro.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/ssl/ssl_intro.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a></p>
</div>


<p>Ce chapitre en guise d'introduction est destin aux lecteurs pour lesquels
le Web, HTTP et Apache sont familiers, mais ne sont pas des experts en matire
de scurit. Il n'a pas la prtention d'tre un guide dtaill sur le
protocole SSL, il ne traitera pas non plus des techniques spcifiques de gestion
des certificats dans une organisation, ni des importants problmes lgaux de
brevets ou des restrictions d'importation ou d'exportation. Il se veut plutt
une base de travail pour les utilisateurs de <code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code> en
rassemblant diffrents concepts, dfinitions et exemples comme point de dpart
pour une exploration plus dtaille.</p>

</div>
<div id="quickview"><ul id="toc"><li><img alt="" src="../images/down.gif" /> <a href="#cryptographictech">Techniques de chiffrement</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#certificates">Certificats</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#ssl">Couche Points d'Accs Scuriss - Secure Sockets Layer (SSL)</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#references">Rfrences</a></li>
</ul><ul class="seealso"><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="cryptographictech" id="cryptographictech">Techniques de chiffrement</a></h2>

<p>La matrise de SSL ncessite la comprhension des algorithmes de
chiffrement, des fonctions relatives aux empreintes de messages (comme les
fonctions de type hash ou non rversibles), et des signatures numriques. Ces
techniques pourraient faire l'objet d'un ouvrage  elles seules (voir par
exemple [<a href="#AC96">AC96</a>]) et constituent les bases de la
confidentialit, de l'intgrit et de l'authentification.</p>

<h3><a name="cryptographicalgo" id="cryptographicalgo">Algorithmes de chiffrement</a></h3>

    <p>Supposons qu'Alice veuille envoyer un message  sa banque pour
    transfrer une certaine somme. Alice souhaiterait que le message soit
    priv, car il contient des informations comme son numro de compte et le
    montant du transfert. Une solution consisterait  utiliser un algorithme de
    chiffrement, technique qui permet de remplacer un message par sa version
    chiffre, illisible jusqu' ce qu'elle soit dchiffre.
    Sous sa forme chiffre,
    le message ne peut tre dchiffr qu'en utilisant une cl secrte. Sans la
    cl, le message est inutilisable : les bons algorithmes de chiffrement
    rendent si difficile la restitution du texte original par des intrus que
    ceux-ci y gaspilleraient leurs efforts.</p>

    <p>Il existe deux catgories d'algorithmes de chiffrement : conventionnel
    ou  cl publique.</p>

    <dl>
    <dt>Chiffrement conventionnel</dt>
    <dd>aussi connu sous le nom de chiffrement symtrique, il ncessite le
    partage d'une cl entre l'expditeur et le destinataire : une portion
    d'information secrte permettant de chiffrer et dchiffrer un message.
    Tant que cette cl reste secrte, personne  part l'expditeur et le
    destinataire ne peut lire le message. Si Alice et sa banque partagent une
    cl secrte, ils peuvent donc s'envoyer l'un  l'autre des messages privs.
    Le fait de partager une cl entre l'expditeur et le destinataire avant
    de communiquer, tout en la maintenant secrte vis  vis des autres, peut
    toutefois poser des problmes.</dd>

    <dt>Chiffrement  cl publique</dt>
    <dd>aussi connu sous le nom de chiffrement asymtrique, il rsoud le
    problme d'change de cl en dfinissant un algorithme qui utilise deux
    cls, chacune d'entre elles pouvant tre utilise pour chiffrer un message.
    Si une des cls a t utilise pour chiffrer le message, on doit utiliser
    l'autre cl pour le dchiffrer. Il est ainsi possible de recevoir des
    messages scuriss simplement en rendant publique une des cls (la cl
    publique), et en gardant l'autre cl secrte (la cl prive).</dd>
    </dl>

    <p>Tout le monde peut chiffrer un message en utilisant la cl publique,
    mais seul le propritaire de la cl prive sera en mesure de le lire. De
    cette faon, Alice peut envoyer des messages privs au propritaire d'une
    paire de cls (sa banque), en les chiffrant  l'aide de la cl publique.
    Seule la banque sera en mesure de les dchiffrer.</p>


<h3><a name="messagedigests" id="messagedigests">Empreinte d'un message</a></h3>

    <p>Bien qu'Alice puisse chiffrer son message pour le rendre priv, il
    subsiste toujours le risque que quelqu'un puisse modifier le message
    original ou le remplacer par un autre, afin d'effectuer le transfert de
    fonds  son profit, par exemple. Une solution pour garantir l'intgrit du
    message consisterait pour Alice  crer un rsum concentr de son message
    qu'elle enverrait  sa banque avec ce dernier. A la rception du message,
    la banque cre son propre rsum et le compare avec celui qu'Alice a
    envoy. Si les deux rsums sont identiques, le message reu n'a pas
    t modifi.</p>

    <p>Un rsum tel que celui-ci est appel
    <dfn>empreinte numrique de message</dfn> (message digest),
    <em>fonction irrversible</em> (one-way function) ou
    <em>fonction de hashage</em> (hash function). Une empreinte de message
    constitue une reprsentation courte et de longueur fixe, d'un message plus
    long et de longueur variable. Les algorithmes de cration d'empreintes sont
    conus pour produire une empreinte unique pour chaque message. Les
    empreintes de messages sont conues pour que la restitution du message
     partir de l'empreinte soit d'une difficult insurmontable, et qu'il soit
    (en thorie) impossible de trouver deux messages diffrents qui produisent
    la mme empreinte -- ce qui limine la possibilit de remplacer un message
    par un autre en conservant la mme empreinte.</p>

    <p>Trouver le moyen d'envoyer l'empreinte de manire scurise  la banque
    constitue un autre dfit auquel Alice doit faire face ; si l'empreinte
    n'est pas envoye de manire scurise, son intgrit peut tre compromise,
    et avec elle, la possibilit pour la banque de vrifier l'intgrit du
    message original. L'intgrit du message ne peut tre vrifie que si
    l'empreinte qui lui est associe est envoye de manire scurise.</p>

    <p>Une solution pour envoyer l'empreinte de manire scurise consiste 
    l'inclure dans une signature numrique.</p>


<h3><a name="digitalsignatures" id="digitalsignatures">Signatures numriques</a></h3>
<p>Quand Alice envoie un message  sa banque, cette dernire doit s'assurer
que le message a bien t envoy par elle, pour viter qu'un intrus puisse
effectuer une transaction sur son compte. Une <em>signature numrique</em>,
cre par Alice et incluse dans le message, permet d'atteindre cet
objectif.</p>

<p>Les signatures numriques peuvent tre cres en chiffrant une empreinte de
message, ainsi que d'autres informations (comme un numro d'ordre) avec la cl
prive de l'expditeur. Bien que tout le monde puisse <em>dchiffrer</em> la
signature  l'aide de la cl publique, seul l'expditeur connait la cl prive.
Ce qui implique que seul l'expditeur peut avoir sign le message. Inclure
l'empreinte dans la signature entrane que cette dernire n'est valable que
pour ce message ; ceci assure aussi l'intgrit du message car personne ne
peut modifier l'empreinte et ensuite signer le message.</p>
<p>Afin de se prmunir contre l'interception et la rutilisation de la
signature par un intrus quelques jours plus tard, la signature contient un
numro d'ordre unique. Ceci protge la banque contre une plainte frauduleuse
de la part d'Alice allguant qu'elle n'a pas envoy le message --
elle seule peut l'avoir sign (non-rpudiation).</p>


</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="certificates" id="certificates">Certificats</a></h2>

<p>Bien qu'Alice soit parvenue  envoyer un message priv  sa banque, aprs
l'avoir sign et avoir ainsi assur l'intgrit du message, elle doit encore vrifier
qu'elle communique rellement avec la banque. C'est  dire qu'elle doit
s'assurer que la cl publique qu'elle utilise appartient bien  la paire de
cls de la banque, et non  celle d'un intrus.
De mme, la banque doit vrifier que la
signature du message a bien t construite avec la cl prive d'Alice.</p>

<p>Si chaque partie possde un certificat qui valide l'identit de l'autre,
confirme la cl publique, et est sign par un organisme de confiance, alors
les deux protagonistes peuvent tre srs que la personne avec laquelle ils
communiquent est bien celle avec laquelle ils dsirent le faire. Un tel
organisme de confiance s'appelle une <em>Autorit de Certification</em>, et
on utilise les certificats  des fins d'authentification.</p>

<h3><a name="certificatecontents" id="certificatecontents">Contenu d'un certificat</a></h3>

    <p>Un certificat associe une cl publique avec l'identit relle d'un
    individu, d'un serveur, ou d'une autre entit plus connue sous le nom de
    sujet. Comme on le voit dans le <a href="#table1">Tableau 1</a>, les
    information concernant le sujet comprennent des informations
    d'identification (le nom distinctif ou distinguished name - dn), ainsi que
    la cl publique. Il comporte aussi l'identification et la signature de
    l'autorit de certification qui a dlivr le certificat, ainsi que la
    priode de validit de ce dernier. Il peut aussi contenir des informations
    supplmentaires (ou extensions) telles que des informations de gestion
    destines  l'autorit de certification, comme un numro de srie.</p>

    <h4><a name="table1" id="table1">Tableau 1: Information contenues dans un certificat</a></h4>
    
    <table>
    
    <tr><th>Sujet</th>
        <td>Nom distinctif, Cl publique</td></tr>
    <tr><th>Fournisseur</th>
        <td>Nom distinctif, Signature</td></tr>
    <tr><th>Priode de validit</th>
        <td>Pas avant, Pas aprs</td></tr>
    <tr><th>Informations de gestion</th>
        <td>Version, Numro de srie</td></tr>
    <tr><th>Extensions</th>
        <td>Contraintes de base, Drapeaux Netscape, etc.</td></tr>
    </table>
    

    <p>Un nom distinctif sert  fournir une identit dans un contexte
    spcifique -- par exemple, un individu peut possder un certificat
    personnel, et aussi un certificat en tant qu'employ. Les noms distinctifs
    doivent respecter le standard X509 [<a href="#X509">X509</a>], qui dfinit
    les champs, les noms de champs, et les abrviations utilises pour faire
    rfrence aux champs (voir <a href="#table2">Tableau 2</a>).</p>

    <h4><a name="table2" id="table2">Tableau 2: Informations contenues dans le nom distinctif</a></h4>
    
    <table class="bordered">
    
    <tr><th>Champ du DN</th>
        <th>Abrv.</th>
        <th>Description</th>
        <th>Exemple</th></tr>
    <tr><td>Nom complet (Common Name)</td>
        <td>CN</td>
        <td>Nom certifi</td>
        <td>CN=Joe Average</td></tr>
    <tr><td>Organisation or Entreprise</td>
        <td>O</td>
        <td>Nom est associ  cette<br />organisation</td>
        <td>O=Snake Oil, Ltd.</td></tr>
    <tr><td>Unit organisationnelle (Organizational Unit)</td>
        <td>OU</td>
        <td>Nom est associ avec cette <br />unit organisationnelle,
	par exemple un dpartement</td>
        <td>OU=Research Institute</td></tr>
    <tr><td>Ville/Localisation</td>
        <td>L</td>
        <td>Nom est localis dans cette ville</td>
        <td>L=Snake City</td></tr>
    <tr><td>Etat/Province</td>
        <td>ST</td>
        <td>Nom est localis dans cet tat/province</td>
        <td>ST=Desert</td></tr>
    <tr><td>Pays</td>
        <td>C</td>
        <td>Nom est localis dans ce pays (code ISO)</td>
        <td>C=XZ</td></tr>
    </table>
    

    <p>Une autorit de certification peut dfinir une contrainte spcifiant
    quels champs du nom distinctif sont optionnels et lesquels sont
    obligatoires. Elle peut aussi imposer des contraintes sur le contenu des
    champs, ce que peuvent aussi faire les utilisateurs de certificats. Par
    exemple, un navigateur Netscape peut exiger, dans le cas d'un certificat
    de serveur, que le nom complet (Common Name) corresponde  un nom gnrique
    contenant le nom de domaine du serveur, comme
    <code>*.snakeoil.com</code>.</p>

    <p>Le format binaire d'un certificat est dfini en utilisant la
    notation ASN.1 [<a href="#ASN1">ASN1</a>] [<a href="#PKCS">PKCS</a>].
    Cette notation definit la manire de spcifier les contenus, et les rgles
    d'encodage dfinissent la manire dont ces information sont converties au
    format binaire. L'encodage binaire du certificat est dfini par les Rgles
    d'Encodage Distinctives (Distinguished Encoding Rules - DER), qui se basent
    d'une manire plus gnrale sur les Rgles d'Encodage de Base (Basic
    Encoding Rules - BER). Pour les transmissions qui ne supportent pas le
    format binaire, ce dernier peut tre converti au format ASCII en utilisant
    le codage Base64 [<a href="#MIME">MIME</a>]. Lorsqu'il est plac entre des
    dlimiteurs de dbut et de fin (comme ci-dessous), on dit que le certificat
    est encod au format PEM ("Privacy Enhanced Mail").</p>

    <div class="example"><h3>Exemple de certificat encod au format PEM (snakeoil.crt)</h3><pre>-----BEGIN CERTIFICATE-----
MIIC7jCCAlegAwIBAgIBATANBgkqhkiG9w0BAQQFADCBqTELMAkGA1UEBhMCWFkx
FTATBgNVBAgTDFNuYWtlIERlc2VydDETMBEGA1UEBxMKU25ha2UgVG93bjEXMBUG
A1UEChMOU25ha2UgT2lsLCBMdGQxHjAcBgNVBAsTFUNlcnRpZmljYXRlIEF1dGhv
cml0eTEVMBMGA1UEAxMMU25ha2UgT2lsIENBMR4wHAYJKoZIhvcNAQkBFg9jYUBz
bmFrZW9pbC5kb20wHhcNOTgxMDIxMDg1ODM2WhcNOTkxMDIxMDg1ODM2WjCBpzEL
MAkGA1UEBhMCWFkxFTATBgNVBAgTDFNuYWtlIERlc2VydDETMBEGA1UEBxMKU25h
a2UgVG93bjEXMBUGA1UEChMOU25ha2UgT2lsLCBMdGQxFzAVBgNVBAsTDldlYnNl
cnZlciBUZWFtMRkwFwYDVQQDExB3d3cuc25ha2VvaWwuZG9tMR8wHQYJKoZIhvcN
AQkBFhB3d3dAc25ha2VvaWwuZG9tMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKB
gQDH9Ge/s2zcH+da+rPTx/DPRp3xGjHZ4GG6pCmvADIEtBtKBFAcZ64n+Dy7Np8b
vKR+yy5DGQiijsH1D/j8HlGE+q4TZ8OFk7BNBFazHxFbYI4OKMiCxdKzdif1yfaa
lWoANFlAzlSdbxeGVHoT0K+gT5w3UxwZKv2DLbCTzLZyPwIDAQABoyYwJDAPBgNV
HRMECDAGAQH/AgEAMBEGCWCGSAGG+EIBAQQEAwIAQDANBgkqhkiG9w0BAQQFAAOB
gQAZUIHAL4D09oE6Lv2k56Gp38OBDuILvwLg1v1KL8mQR+KFjghCrtpqaztZqcDt
2q2QoyulCgSzHbEGmi0EsdkPfg6mp0penssIFePYNI+/8u9HT4LuKMJX15hxBam7
dUHzICxBVC1lnHyYGjDuAMhe396lYAn8bCld1/L4NMGBCQ==
-----END CERTIFICATE-----</pre></div>


<h3><a name="certificateauthorities" id="certificateauthorities">Autorits de certification</a></h3>

    <p>En vrifiant les informations contenues dans une demande de certificat
    avant de l'accorder, l'autorit de certification s'assure de l'identit du
    propritaire de la cl prive issue de sa paire de cls. Par exemple, Si
    Alice demande un certificat personnel, l'autorit de certification doit
    d'abord s'assurer qu'elle correspond vraiment  la personne  laquelle
    la demande de certificat fait rfrence.</p>

    <h4><a name="certificatechains" id="certificatechains">Chanes de certification</a></h4>
    
        <p>Une autorit de certification peut aussi mettre un certificat 
	destination d'une
	autre autorit de certification. Pour vrifier un certificat, Alice
	peut tre amene  vrifier le certificat de l'metteur pour chaque
	autorit de certification parente, jusqu' ce qu'elle en atteigne une
	en qui elle a confiance. Elle peut aussi ne faire confiance qu'aux
	certificats faisant l'objet d'une chane limite d'metteurs, afin
	de rduire le risque de rencontrer un "mauvais" certificat dans la
	chane.</p>
    

    <h4><a name="rootlevelca" id="rootlevelca">Cration d'une autorit de certification racine</a></h4>
    
        <p>Comme indiqu plus haut, chaque certificat ncessite la validation
	de l'identit du sujet par un metteur de certificats
	de niveau suprieur, et ceci en
	remontant jusqu' l'Autorit de Certification (CA) racine. Ceci pose un
	problme : qui va se porter garant du certificat de l'autorit racine
	qui ne possde pas d'metteur de certificat ? C'est uniquement dans ce
	cas que le certificat est auto-sign, l'metteur du certificat et son
	sujet tant confondus. Les navigateurs sont prconfigurs avec une
	liste d'autorits de certification de confiance, mais il est important
	d'tre extrmement prudent avant de faire confiance  un certificat
	auto-sign. La large publication d'une cl publique par l'autorit
	racine rduit cependant les risques encourus
	en faisant confiance  cette cl --
	si quelqu'un publiait une cl en se faisant passer pour l'autorit, il
	serait vite dmasqu.</p>

        <p>Quelques compagnies, comme <a href="http://www.thawte.com/">Thawte</a> et <a href="http://www.verisign.com/">VeriSign</a>,
	se sont proclames elles-mmes Autorits de Certification. Ces
	compagnies proposent les services suivant :</p>

        <ul>
        <li>Vrification des demandes de certificats</li>
        <li>Traitement des demandes de certificats</li>
        <li>Emission et gestion des certificats</li>
        </ul>

        <p>Vous pouvez aussi crer votre propre autorit de certification. Bien
	que risqu dans l'environnement de l'Internet, ceci peut s'avrer utile
	dans un Intranet, o l'organisme peut vrifier facilement les identits
	des individus et des serveurs.</p>
    

    <h4><a name="certificatemanagement" id="certificatemanagement">Gestion des certificats</a></h4>
    
        <p>Constituer une autorit de certification reprsente une
	responsabilit qui ncessite une solide infrastructure administrative,
	technique et gestionnaire. Les autorits de certification ne se
	contentent pas d'mettre des certificats, elles doivent aussi les grer
	--  savoir elles dterminent leur dure de validit, elles les
	renouvellent, et elles maintiennent des listes de certificats qui ont
	t mis dans le pass mais ne sont plus valides (Listes de rvocations
	de certificats, ou CRLs).</p>

        <p>Par exemple, si Alice est titulaire d'un certificat en tant
	qu'employe d'une compagnie, mais vient de quitter cette compagnie,
	son certificat doit tre rvoqu. Comme les certificats ne sont mis
	qu'aprs vrification de l'identit du sujet, et peuvent tre envoys
	 tous ceux avec lesquels le sujet peut communiquer, il est impossible
	de discerner  partir du seul certificat s'il a t rvoqu. Pour
	vrifier la validit d'un certificat, il est donc ncessaire de
	contacter l'autorit de certification qui l'a mis afin de pouvoir
	consulter ses listes de rvocations de certificats -- ce qui n'est
	en gnral pas une partie automatique du processus.</p>

        <div class="note"><h3>Note</h3>
        <p>Si votre autorit de certification ne fait pas partie de la liste
	des autorits de confiance de votre navigateur, il faut enregistrer le
	certificat de l'autorit de certification dans ce dernier, ce qui lui
	permettra de valider les certificats de serveurs signs par cette
	autorit de certification. Ceci peut tre dangereux, car une fois le
	certificat enregistr, le navigateur acceptera tous les certificats
	signs par cette autorit de certification.</p>
        </div>
    


</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="ssl" id="ssl">Couche Points d'Accs Scuriss - Secure Sockets Layer (SSL)</a></h2>

<p>Le protocole Couche Points d'Accs Scuriss est une couche protocolaire
qui pourrait s'intercaler entre un protocole d'une couche rseau oriente
connexion (comme TCP/IP) et une couche protocolaire d'application (comme HTTP).
SSL fournit une communication scurise entre client et serveur en permettant
l'authentification mutuelle, l'utilisation des signatures numriques pour la
vrification de l'intgrit des donnes, et le chiffrement pour la
confidentialit.</p>

<p>Ce protocole est conu pour supporter un grand choix d'algorithmes
spcifiques utiliss pour la cryptographie, les empreintes et les signatures.
Ceci permet la slection d'un algorithme pour des serveurs spcifiques en
respectant la lgalit, les rgles d'exportation ou autres contraintes, et
permet aussi au protocole de tirer parti des nouveaux algorithmes. Ces choix
font l'objet d'une ngociation entre client et serveur lors de
l'tablissement de la session protocolaire.</p>

<h3><a name="table4" id="table4">Tableau 4: Versions du protocole SSL</a></h3>

    <table class="bordered">
    
    <tr><th>Version</th>
        <th>Source</th>
        <th>Description</th>
    </tr>
    <tr><td>SSL v2.0</td>
        <td>Standard du fournisseur (de Netscape Corp.)</td>
        <td>Premier protocole SSL pour lequel il existe des implmentations</td>
    </tr>
    <tr><td>SSL v3.0</td>
        <td>Projet Internet arriv  expiration (de Netscape Corp.) [<a href="#SSL3">SSL3</a>]</td>
        <td>Comporte des rvisions permettant de prvenir certaines attaques de
	scurit spcifiques, ajout de chiffrements non RSA, et support des
	chanes de certification</td>
    </tr>
    <tr><td>TLS v1.0</td>
        <td>Standard propos pour l'Internet (de l'IETF) [<a href="#TLS1">TLS1</a>]</td>
        <td>Rvision de SSL 3.0 pour mettre  jour la couche MAC vers HMAC,
	ajout du bourrage de bloc pour le chiffrement de bloc, standardisation
	de l'ordonnancement des messages et plus de messages d'alerte.</td>
    </tr>
	<tr><td>TLS v1.1</td>
        <td>Standard propos pour l'Internet (de l'IETF) [<a href="#TLS11">TLS11</a>]</td>
        <td>Mise  jour de TLS 1.0 pour la protection contre les
	attaques de type Cipher block chaining (CBC).</td>
    </tr>
    <tr><td>TLS v1.2</td>
        <td>Standard propos pour l'Internet (de l'IETF) [<a href="#TLS12">TLS12</a>]</td>
        <td>Mise  jour de TLS 1.2 rendant les condenss MD5 obsoltes,
	et introduisant une incompatibilit avec SSL ce qui interdit toute
	ngociation en vue d'une utilisation de SSLv2.</td>
    </tr>
    </table>


<p>Il existe plusieurs versions du protocole SSL, comme le montre le
<a href="#table4">Tableau 4</a>. Comme indiqu dans ce dernier, un des apports
de SSL 3.0 est le support du chargement des chanes de certification. Cette
fonctionnalit permet  un serveur de passer au navigateur un certificat de
serveur accompagn du certificat de l'metteur. Le chargement de la
chane permet aussi au navigateur de valider le certificat du serveur, mme si
les certificats de l'autorit de certification ne sont pas installs pour les
metteurs intermdiaires, car ils sont inclus dans la chane de certification.
SSL 3.0 sert de base au standard du protocole Scurit de la Couche Transport
ou Transport Layer Security
[<a href="#TLS1">TLS</a>], actuellement en dveloppement au sein de
l'Internet Engineering Task Force (IETF).</p>

<h3><a name="session" id="session">Etablissement d'une session</a></h3>

    <p>La session SSL est tablie en suivant une squence d'changes
    d'informations entre client et serveur, comme le montre la
    <a href="#figure1">Figure 1</a>. Cette squence peut varier, selon que
    le serveur est configur pour fournir un certificat de serveur ou
    rclame un certificat client. Bien que dans certains cas, des tapes
    d'changes d'informations supplmentaires soient ncessaires pour la
    gestion des informations de chiffrement, cet article rsume un scnario
    courant. Se reporter aux spcifications SSL pour avoir la liste de
    toutes les possibilits.</p>

    <div class="note"><h3>Note</h3>
    <p>Une fois la session SSL tablie, elle peut tre rutilise. Ceci
    permet d'viter la perte de performances due  la rptition des nombreuses
    tapes ncessaires  l'tablissement d'une session. Pour parvenir  ceci,
    le serveur assigne un identifiant de session unique  chaque session SSL ;
    cet identifiant est mis en cache dans le serveur et le client peut
    l'utiliser pour des connexions ultrieures afin de rduire la dure des
    changes d'informations (et ceci jusqu' ce que l'identifiant de session
    arrive  expiration dans le cache du serveur).</p>
    </div>

    <p class="figure">
    <img src="../images/ssl_intro_fig1.gif" alt="" width="423" height="327" /><br />
    <a id="figure1" name="figure1"><dfn>Figure 1</dfn></a> : Squence
    simplifie d'changes d'informations SSL</p>

    <p>Les lments de la squence d'changes d'informations, tels qu'ils
    sont utiliss par le client et le serveur, sont numrs ci-aprs :</p>

    <ol>
    <li>Ngociation de la suite de chiffrement  utiliser durant le transfert des donnes</li>
    <li>Elaboration et change d'une cl de session entre le client et le serveur</li>
    <li>Authentification ventuelle du serveur par le client</li>
    <li>Authentification ventuelle du client par le serveur</li>
    </ol>

    <p>La premire tape, la ngociation de la suite de chiffrement, permet au
    client et au serveur de choisir une suite de chiffrement qu'ils supportent
    tous les deux. La spcification du protocole SSL 3.0 dfinit 31 suites de
    chiffrement. Une suite de chiffrement se compose des lments
    suivants :</p>

    <ul>
    <li>Mthode d'change de la cl</li>
    <li>Chiffrement du transfert des donnes</li>
    <li>Empreinte du message servant  crer le code d'authentification du
    message (MAC)</li>
    </ul>

    <p>Ces trois lments sont dcrits dans les sections suivantes.</p>


<h3><a name="keyexchange" id="keyexchange">Mthode d'change de la cl</a></h3>

    <p>La mthode d'change de la cl dfinit la manire
    dont la cl de chiffrement
    symtrique secrte et partage utilise pour le transfert des donnes de
    l'application sera accepte par le client et le serveur. SSL 2.0 utilise
    l'change de cl RSA seulement, tandis que SSL 3.0 supporte tout un choix
    d'algorithmes d'change de cl incluant l'change de cl RSA (quand les
    certificats sont utiliss), et l'change de cls Diffie-Hellman (pour
    changer des cls sans certificat, ou en l'absence de communication
    pralable entre le client et le serveur).</p>

    <p>Les signatures numriques constituent une variante dans le choix des
    mthodes d'change de cl -- utiliser les signatures ou pas, et dans
    l'affirmative, quel genre de signatures utiliser. La signature  l'aide
    d'une cl prive fournit une protection contre une attaque
    "man-in-the-middle" au cours de laquelle
    l'change d'informations destin  gnrer la
    cl partage peut tre intercept [<a href="#AC96">AC96</a>, p516].</p>


<h3><a name="ciphertransfer" id="ciphertransfer">Chiffrement du transfert de donnes</a></h3>

    <p>Comme dcrit plus haut, SSL utilise le chiffrement symtrique
    conventionnel pour chiffrer les messages au cours d'une session. Il existe
    neuf choix possibles pour le chiffrement, y compris l'option du transfert
    non chiffr :</p>

    <ul>
    <li>Pas de chiffrement</li>
    <li>Chiffrement en continu (Stream Ciphers)
        <ul>
        <li>RC4 avec cls de 40 bits</li>
        <li>RC4 avec cls de 128 bits</li>
        </ul></li>
    <li>Chiffrement par blocs CBC (CBC Block Ciphers)
        <ul><li>RC2 avec cl de 40 bits</li>
        <li>DES avec cl de 40 bits</li>
        <li>DES avec cl de 56 bits</li>
        <li>Triple-DES avec cl de 168 bits</li>
        <li>Idea (cl de 128 bits)</li>
        <li>Fortezza (cl de 96 bits)</li>
        </ul></li>
    </ul>

    <p>"CBC" signifie Cipher Block Chaining (Chanage de blocs chiffrs),
    c'est  dire qu'une portion du bloc de texte chiffr prcdent est utilise
    pour le chiffrement du bloc courant. "DES" signifie Data Encryption
    Standard (Standard de Chiffrement des Donnes)
    [<a href="#AC96">AC96</a>, ch12], et possde de nombreuses variantes
    (telles que DES40 et 3DES_EDE). Parmi les algorithmes disponibles, "Idea"
    est actuellement un des meilleurs et des plus puissants sur le plan
    cryptographique, et "RC2" est un algorithme propritaire de RSA DSI
    [<a href="#AC96">AC96</a>, ch13].</p>


<h3><a name="digestfuntion" id="digestfuntion">Fonction de cration d'empreinte</a></h3>

    <p>Le choix d'une fonction de cration d'empreinte dtermine la manire
    dont une empreinte est cre  partir d'une unit de donnes. SSL supporte
    les fonctions suivantes :</p>

    <ul>
    <li>Pas d'empreinte (choix Null)</li>
    <li>MD5, une empreinte de 128 bits</li>
    <li>Algorithme d'Empreinte Scurise (Secure Hash Algorithm - SHA-1), une
    empreinte de 160 bits</li>
    </ul>

    <p>On utilise l'empreinte de message pour crer un Code d'Authentification
    de Message (Message Authentication Code - MAC) qui est chiffr avec le
    message afin de vrifier son intgrit et de se protger contre les
    attaques de type "rejeu".</p>


<h3><a name="handshake" id="handshake">Protocole de la squence d'changes d'informations</a></h3>

    <p>La squence d'changes d'informations utilise trois protocoles :</p>

    <ul>
    <li>Le <dfn>Protocole d'changes d'informations SSL</dfn> pour tablir
    la session SSl entre le client et le serveur.</li>
    <li>Le <dfn>Protocole de spcification du chiffrement SSL</dfn> pour
    l'agrment effectif de la suite de chiffrement  utiliser
    pour la session.</li>
    <li>Le <dfn>Protocole d'alertes SSL</dfn> pour la transmission de
    messages d'erreur SSL entre le client et le serveur.</li>
    </ul>

    <p>Ces protocoles, ainsi que les donnes du protocole de l'application,
    sont encapsuls dans le <dfn>Protocole d'enregistrement SSL
    (SSL Record Protocol)</dfn>, comme
    le montre la <a href="#figure2">Figure 2</a>. Un protocole encapsul est
    tranfr en tant que donnes par le protocole de la couche de niveau
    infrieur, qui ne se proccupe pas du contenu des donnes. Le protocole
    encapsul n'a aucune connaissance du protocole sous-jacent.</p>

    <p class="figure">
    <img src="../images/ssl_intro_fig2.gif" alt="" width="428" height="217" /><br />
    <a id="figure2" name="figure2"><dfn>Figure 2</dfn></a>:
    Pile du protocole SSL</p>

    <p>L'encapsulation des protocoles de contrle SSL dans le protocole
    d'enregistrement signifie que si une session active est rengocie, les
    protocoles de contrle seront transmis de manire scurise. S'il n'y
    avait pas de session pralable, la suite de chiffrement Null est utilise,
    ce qui signifie que les messages ne seront pas chiffrs et ne possderont
    pas d'empreinte d'intgrit, jusqu' ce que la session ait t tablie.</p>


<h3><a name="datatransfer" id="datatransfer">Transmission des donnes</a></h3>

    <p>Le protocole d'enregistrement SSL, comme le montre la
    <a href="#figure3">Figure 3</a>, est utilis pour transmettre les donnes
    de l'application et les donnes de contrle SSL entre le client et le
    serveur, les donnes tant ncessairement fragmentes en lments plus
    petits, ou plusieurs messages de donnes avec protocole de niveau
    suprieur pouvant tre combins en un seul lment. Ce protocole peut
    joindre des signatures d'empreintes, compresser et chiffrer ces lments
    avant de les transmettre en utilisant le protocole fiable de transport
    sous-jacent (Note : actuellement, aucune implmentation majeure de SSL
    n'inclut le support de la compression).</p>

    <p class="figure">
    <img src="../images/ssl_intro_fig3.gif" alt="" width="423" height="323" /><br />
    <a id="figure3" name="figure3"><dfn>Figure 3</dfn></a>:
    Protocole d'enregistrement SSL</p>


<h3><a name="securehttp" id="securehttp">Scurisation des communications HTTP</a></h3>

    <p>Une des utilisations courantes de SSL est la scurisation des
    communication HTTP sur le Web entre un navigateur et un serveur web. Ceci
    n'exclut pas l'utilisation de HTTP non scuris - la version scurise
    (appele HTTPS) est identique  du vrai HTTP sur SSL,
    mais utilise le prfixe
    d'URL <code>https</code> au lieu de <code>http</code>, et un port
    de serveur diffrent (par dfaut le port 443).
    Ceci constitue pour une large part
    ce qu'apporte <code class="module"><a href="../mod/mod_ssl.html">mod_ssl</a></code> au serveur web Apache.</p>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="references" id="references">Rfrences</a></h2>

<dl>
<dt><a id="AC96" name="AC96">[AC96]</a></dt>
<dd>Bruce Schneier, <q>Applied Cryptography</q>, 2nd Edition, Wiley,
1996. Voir <a href="http://www.counterpane.com/">http://www.counterpane.com/</a> pour diverses autres productions de Bruce
Schneier.</dd>

<dt><a id="ASN1" name="ASN1">[ASN1]</a></dt>
<dd>ITU-T Recommendation X.208, <q>Specification of Abstract Syntax Notation
One (ASN.1)</q>, dernire mise  jour en 2008. Voir <a href="http://www.itu.int/ITU-T/asn1/">http://www.itu.int/ITU-T/asn1/</a>.
</dd>

<dt><a id="X509" name="X509">[X509]</a></dt>
<dd>ITU-T Recommendation X.509, <q>The Directory - Authentication
Framework</q>. A titre de rfrence, voir <a href="http://en.wikipedia.org/wiki/X.509">http://en.wikipedia.org/wiki/X.509</a>.
</dd>

<dt><a id="PKCS" name="PKCS">[PKCS]</a></dt>
<dd><q>Public Key Cryptography Standards (PKCS)</q>,
RSA Laboratories Technical Notes, Voir <a href="http://www.rsasecurity.com/rsalabs/pkcs/">http://www.rsasecurity.com/rsalabs/pkcs/</a>.</dd>

<dt><a id="MIME" name="MIME">[MIME]</a></dt>
<dd>N. Freed, N. Borenstein, <q>Multipurpose Internet Mail Extensions
(MIME) Part One: Format of Internet Message Bodies</q>, RFC2045.
Voir par exemple <a href="http://tools.ietf.org/html/rfc2045">http://tools.ietf.org/html/rfc2045</a>.</dd>

<dt><a id="SSL3" name="SSL3">[SSL3]</a></dt>
<dd>Alan O. Freier, Philip Karlton, Paul C. Kocher, <q>The SSL Protocol
Version 3.0</q>, 1996. Voir <a href="http://www.netscape.com/eng/ssl3/draft302.txt">http://www.netscape.com/eng/ssl3/draft302.txt</a>.</dd>

<dt><a id="TLS1" name="TLS1">[TLS1]</a></dt>
<dd>Tim Dierks, Christopher Allen, <q>The TLS Protocol Version 1.0</q>,
1999. Voir <a href="http://ietf.org/rfc/rfc2246.txt">http://ietf.org/rfc/rfc2246.txt</a>.</dd>

<dt><a id="TLS11" name="TLS11">[TLS11]</a></dt>
<dd><q>Le protocole TLS Version 1.1</q>,
2006. Voir <a href="http://tools.ietf.org/html/rfc4346">http://tools.ietf.org/html/rfc4346</a>.</dd>

<dt><a id="TLS12" name="TLS12">[TLS12]</a></dt>
<dd><q>Le protocole TLS Version 1.2</q>,
2008. Voir <a href="http://tools.ietf.org/html/rfc5246">http://tools.ietf.org/html/rfc5246</a>.</dd>
</dl>
</div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/ssl/ssl_intro.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/ssl/ssl_intro.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="../ja/ssl/ssl_intro.html" hreflang="ja" rel="alternate" title="Japanese">&nbsp;ja&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/ssl/ssl_intro.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2015 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>