( cd etc/apache2/sites-enabled ; rm -rf 000-default )
( cd etc/apache2/sites-enabled ; ln -sf ../sites-available/default 000-default )

echo
if ! egrep -q '^httpd:' $ROOT/etc/group; then
   echo "Agregando grupo httpd"
   groupadd -g 25 httpd
fi
if ! egrep -q '^httpd:' $ROOT/etc/passwd; then
   echo "Agregando usuario httpd"
   useradd -s /bin/false -d /dev/null -g httpd -u 25 httpd
fi

for confdir in /etc /var/named; do 
                find $ROOT/$confdir -name '*.new' | while read i; do 
                        BASE=$(dirname $i)/$(basename $i .new) 
                        echo Verificando $BASE 
                        if [ -f $BASE ]; then 
                                rm -f $i 
                        else 
                                mv -v $i $BASE 
                        fi 
                done; 
done

# Fix a previous package version that included
# the /etc/apache2/sites-available/default file without the .new file name extension

# Remember that upgradepkg performs the upgrade in three stages:
# 1) Pre-install the new package
# 2) Remove the old package
# 3) Install the new package again

default_site="$ROOT/etc/apache2/sites-available/default"
bakext=httpd-itk-2.2.27-i686-5.bak
# This will save the file when upgradepkg pre-installs the new package
if [ -f "$default_site" ]; then
   [ -f "${default_site}.$bakext" ] || cp -v "$default_site" "${default_site}.$bakext"
fi 

# This will restore it after the old package has been deleted
# and upgradepkg installs the new package again
[ -f "${default_site}.$bakext" ] && cp -v "${default_site}.$bakext" "$default_site"
