#!/bin/sh
#
# /etc/iproute2/dhcp-sust.sh
#
# Recrea de manera dinamica los archivos de configuracion de
# iproute2 cuando hay interfaces configuradas via DHCP.
#
# Deberia ser invocado desde /etc/dhcpcd.sh. Ejemplo:
#
# /etc/iproute2/dhcp-sust "$@"
#
# 15abr2011a
#

####### Variables ########

IP=/sbin/ip
IPCALC=/usr/bin/ipcalc

##########################


estado="$2"
# Solamente queremos hacer sustituciones si el estado es "up" o "new"

if [ $estado = "up" -o $estado = "new" ]; then

  # No queremos la ruta por default, la sustituiremos por una multilink
  /sbin/route del default
  
  if [ -r "$1" ]; then
     infofile=$1
  else
     echo "$0: no puedo leer el archivo de informacion DHCP ($1)" | logger -t `basename $0`
     exit 1
  fi
  
  source "$infofile"
  
  # Borramos las tablas antes de modificarlas porque lo que borramos
  # es lo que leemos en este momento del archivo de tabla.
  /etc/rc.d/rc.iproute2 stop
  $IP route flush cache

  for arch in /etc/iproute2/{rutas.in,reglas.in,tablas/*.in}; do
  
  # Sustituimos:
  #   {IP-<interfaz>}
  #   {GW-<interfaz>}
  #   {NM-<interfaz>}
  #   {NET-<interfaz>}

  
  if [ -r "${arch}" ]; then
     S_NET=$( $IPCALC -nb ${IPADDR} ${NETMASK} | egrep "Network:" | sed 's/^.*:[[:blank:]]*//g;s/\//\\\//g' )
     ORIG="${arch}"
     DEST=$( echo ${arch} | sed 's/\.in$//g' )


     sed "s/{IP-${INTERFACE}}/${IPADDR}/g;
          s/{NM-${INTERFACE}}/${NETMASK}/g;
          s/{NET-${INTERFACE}}/${S_NET}/g;
          s/{GW-${INTERFACE}}/${GATEWAYS}/g" < "$ORIG" > "$DEST"
  fi
  
  done
  
  /etc/rc.d/rc.iproute2 start

fi

exit 0
  
  
