for confdir in /etc; do 
		find $ROOT/$confdir -name '*.new' | while read i; do 
			BASE=$(dirname $i)/$(basename $i .new) 
			echo Verificando $BASE 
			if [ -f $BASE ]; then 
				rm -f $i 
			else 
				mv -v $i $BASE 
			fi 
		done; 
done
# Fix a previous package version that included
# the /etc/slapt-get/slapt-getrc file without the .new file name extension

# Remember that upgradepkg performs the upgrade in three stages:
# 1) Pre-install the new package
# 2) Remove the old package
# 3) Install the new package again

sgetrc=$ROOT/etc/slapt-get/slapt-getrc
bakext=slapt-get-0.10.2s-i686-4.bak
# This will save the file when upgradepkg pre-installs the new package
if [ -f "$sgetrc" ]; then
   [ -f "${sgetrc}.$bakext" ] || cp -v "$sgetrc" "${sgetrc}.$bakext"
fi 

# This will restore it after the old package has been deleted
# and upgradepkg installs the new package again
[ -f "${sgetrc}.$bakext" ] && cp -v "${sgetrc}.$bakext" "$sgetrc"
( cd usr/lib ; rm -rf libslapt.so )
( cd usr/lib ; ln -sf libslapt.so.0.10.2s libslapt.so )
