/***************************************************************************
 *
 * echon.c
 * Displays a message and adds argv[1] spaces afterwards without new line,
 * suitable for displaying an (OK|FAIL) message at the end.
 *
 *  Copyright (C) 2000 Felipe Eduardo Sanchez Diaz Duran
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; specifically version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 ****************************************************************************/
 

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

int main (int argc, char **argv) {

 char copyright[] = "Copyright (C) 2000 Felipe Eduardo Sanchez Diaz Duran";
 int cols;
 int centradores;
 int msg_index;
 int i;
 char *cols_env;

 
 switch (argc) {
    case 1:
       putchar('\n');
       exit (0);
       break;
    case 2:
       cols_env = getenv("COLUMNS");
       if (cols_env) cols = atoi(cols_env) - 20; else cols = 60;
       msg_index = 1;
       break;
    default:
       if ( (cols = atoi(argv[1])) < 1 ) {
          cols_env = getenv("COLUMNS");
          if (cols_env) cols = atoi(cols_env) - 20; else cols = 60;
       }
       msg_index = 2;
       break;

 }

 centradores = cols - strlen (argv[msg_index]);
 if (centradores < 0 ) centradores = 0;
 printf ("%s", argv[msg_index]);
 for (i = 1; i < centradores; i++) putchar (' ');

 exit (0);

}

 
