/***************************************************************************
 *
 * linecut.c
 * Prints stdin to stdout, inserting a newline after\nevery MAXCHARS characters
 * of input.
 *
 *  Copyright (C) 2000-2015 Felipe Eduardo Sanchez Diaz Duran
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; specifically version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 ****************************************************************************/
 

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define MAXCHARS 320

int main (int argc, char **argv) {

 char copyright[] = "linecut 0.0.3, Copyright (C) 2000-2015 Felipe Eduardo Sanchez Diaz Duran\n";
 char car;
 int count = 0;

 if (argc == 2) if (strcmp (argv[1], "-V")) {
    puts (copyright);
    printf ("Prints stdin to stdout, inserting a newline after\nevery %d characters of input.\n", MAXCHARS);
    exit (1);
 }
 
 while ( (car = fgetc(stdin)) != EOF) {
    fputc (car, stdout);
    if ( ++count > MAXCHARS - 1 ) {
       fputc ('\n', stdout);
       count = 0;
    }
 }
 exit (0);

}
 

