#!/bin/sh
#
# rc.M		This file is executed by init(8) when the system is being
#		initialized for one of the "multi user" run levels (i.e.
#		levels 1 through 6).  It usually does mounting of file
#		systems et al.
#
# Version:	@(#)/etc/rc.d/rc.M	2.23	Wed Feb 26 19:20:58 PST 2003
#
# Author:	Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
#		Heavily modified by Patrick Volkerding <volkerdi@slackware.com>
#

source /etc/rc.d/funciones.rc

# Tell the viewers what's going to happen.
echo "Going multiuser..."

# Update all the shared library links:
if [ -x /sbin/ldconfig ]; then
  echon "Updating shared library links"
  /sbin/ldconfig &
  okfail $?
fi

# Screen blanks after 15 minutes idle time, and powers down in one hour
# if the kernel supports APM or ACPI power management:
/bin/setterm -blank 15 -powersave powerdown -powerdown 60


# Set the hostname.
if [ -r /etc/HOSTNAME ]; then
  /bin/hostname $(cat /etc/HOSTNAME | cut -f1 -d .)
else
  # fall back on this old default:
  echo "iztaci.local" > /etc/HOSTNAME
  /bin/hostname iztaci
fi
# Save the contents of 'dmesg':
/bin/dmesg -s 65536 > /var/log/dmesg



# Start the syslogd and klogd daemons:
if [ -x /usr/sbin/syslogd -a -d /var/log ]; then
  echo "Starting sysklogd daemons:  "
  echon "   syslogd"
  inicia_proceso -q /usr/sbin/syslogd
  sleep 1 # prevent syslogd/klogd race condition on SMP kernels
  echon "   klogd"
  # '-c 3' = display level 'error' or higher messages on console
  inicia_proceso -q /usr/sbin/klogd -c 3
fi
# Done starting the syslogd and klogd daemons.




# If we are returning from single-user mode we will need to restart
# udevd on systems that use udev:
if grep -wq sysfs /proc/mounts && grep -wq tmpfs /proc/filesystems ; then
  if ! grep -wq nohotplug /proc/cmdline ; then
    if [ -x /etc/rc.d/rc.udev ]; then
      /bin/sh /etc/rc.d/rc.udev start
    fi
  fi
fi


# Initialize the networking hardware.
if [ -x /etc/rc.d/rc.net ]; then
  rm -f /var/run/dhcpcd-*.pid
  /etc/rc.d/rc.net start
fi

# Safety first Enable firewall.
if [ -x /etc/rc.d/rc.firewall ]; then
  /etc/rc.d/rc.firewall start
fi

# Look for additional USB/SCSI/IEEE1394/etc devices on multiple LUNs:
if [ -x /etc/rc.d/rc.scanluns ]; then
  /etc/rc.d/rc.scanluns
fi


# Mount any additional filesystem types that haven't already been mounted:
echo "Montando sistemas de archivo adicionales"
mount -a -v 2> /dev/null | grep -v "already mounted"


# Start the Network Time Protocol daemon:
if [ -x /etc/rc.d/rc.ntpd ]; then
  sh /etc/rc.d/rc.ntpd start
fi


# Remove stale locks and junk files (must be done after mount -a!)
/bin/rm -f /var/lock/* /var/spool/uucp/LCK..* /tmp/.X*lock /tmp/core /core 2> /dev/null

# Remove stale hunt sockets so the game can start.
if [ -r /tmp/hunt -o -r /tmp/hunt.stats ]; then
  echo "Removing your stale hunt sockets from /tmp."
  /bin/rm -f /tmp/hunt*
fi

# Ensure basic filesystem permissions sanity.
chmod 755 / 2> /dev/null
chmod 1777 /tmp /var/tmp

if [ -x /etc/rc.d/rc.acpid ]; then
   /etc/rc.d/rc.acpid start
fi



# Start smartd, which monitors the status of S.M.A.R.T. compatible
# hard drives and reports any problems.  Note some devices (which aren't
# smart, I guess ;) will hang if probed by smartd, so it's commented out
# by default.
#if [ -x /usr/sbin/smartd ]; then
#  /usr/sbin/smartd
#fi

# If we're using udev, make /dev/cdrom and any other optical drive symlinks
# if some udev rule hasn't made them already:
if grep -wq sysfs /proc/mounts && grep -wq tmpfs /proc/filesystems; then
  if ! grep -wq nohotplug /proc/cmdline ; then
    if [ -x /lib/udev/rc.optical-symlinks -a -x /etc/rc.d/rc.udev ]; then
      /bin/sh /lib/udev/rc.optical-symlinks
    fi
  fi
fi

# Monitor the UPS with genpowerd.
# To use this, uncomment this section and edit your settings in
# /etc/genpowerd.conf (serial device, UPS type, etc).  For more information,
# see "man genpowerd" or the extensive documentation in the
# /usr/doc/genpower-1.0.3 directory.
# You'll also need to configure a similar block in /etc/rc.d/rc.6 if you want
# support for stopping the UPS's inverter after the machine halts.
#if [ -x /sbin/genpowerd ]; then
#  echo "Starting genpowerd daemon..."
#  /sbin/genpowerd
#fi

# Turn on process accounting.  To enable process accounting, make sure the
# option for BSD process accounting is enabled in your kernel, and then
# create the file /var/log/pacct (touch /var/log/pacct).  By default, process
# accounting is not enabled (since /var/log/pacct does not exist).  This is
# because the log file can get VERY large.
if [ -x /sbin/accton -a -r /var/log/pacct ]; then
  /sbin/accton /var/log/pacct
  chmod 640 /var/log/pacct
  echo "Process accounting turned on."
fi


# Start crond (Dillon's crond):
# If you want cron to actually log activity to /var/log/cron, then change
# -l10 to -l8 to increase the logging level.
if [ -x /usr/sbin/crond ]; then
  echon "Iniciando crond"
  /usr/sbin/crond -l10 >>/var/log/cron 2>&1
  okfail $?
fi


# Start atd (manages jobs scheduled with 'at'):
if [ -x /usr/sbin/atd ]; then
  inicia_proceso /usr/sbin/atd -b 15 -l 1
fi


# Start OpenSSH server
[ -x /etc/rc.d/rc.sshd ] && /etc/rc.d/rc.sshd start


# If there are SystemV init scripts for this runlevel, run them.
if [ -x /etc/rc.d/rc.sysvinit ]; then
  /etc/rc.d/rc.sysvinit
fi


# Start the inetd server:
if [ -x /usr/sbin/inetd ]; then
  inicia_proceso /usr/sbin/inetd >> /var/log/startup/`basename $0` 2>&1
fi

# Iniciar servicios en /etc/rc.d/servicios
for serv in /etc/rc.d/servicios/*; do
       [ -x $serv ] && $serv start
done

# Start the local setup procedure.
if [ -x /etc/rc.d/rc.local ]; then
  /etc/rc.d/rc.local
fi


# All done.
