#!/bin/sh

if [ ! -r VERSION ]; then
   echo "No puedo leer el archivo VERSION"
   exit 1
fi

if [ ! -d .git ]; then
   echo "Debes correr este script desde la raiz del repositorio git de rc-scripts-iztaci"
   exit 1
fi

NAME="rc-scripts-iztaci"
VERSION=`cat VERSION`
BASENAME=${NAME}-${VERSION}
FILENAME="${BASENAME}.tar.gz"

echo "Creando distribucion para ${BASENAME}..."
if [ -r "$FILENAME" ]; then
   echo "*** Ya hay un archivo $FILENAME. Eliminalo si deseas crear uno nuevo."
   exit 1
else
   mkdir ${BASENAME}
   tar c  --exclude=.git --exclude="$FILENAME" --exclude="$BASENAME" . | tar xC "$BASENAME"
   tar cv "$BASENAME" | gzip -9 > ${FILENAME}
fi
