#-*- mode: Fundamental; tab-width: 4; -*-
# ex:ts=4 sw=4

# Copyright (C) 2001 Nick Moffitt
# 
# Redistribution and/or use, with or without modification, is
# permitted.  This software is without warranty of any kind.  The
# author(s) shall not be liable in the event that use of the
# software causes damage.

# Comment this out to make much verbosity
#.SILENT:

define newline


endef

comma := ,

#ifeq ($(origin GARDIR), undefined)
#GARDIR := $(CURDIR)/../..
#endif

####### Invariants #######
GARDIR ?= ../..

# GARBUILD is the platform on which you're running GAR.  If you want to
# override it with a value other than what GCC thinks it's running on that's
# ok, but the results will be very... VERY ...strange.
GARBUILD ?= $(shell $(CC) -dumpmachine)

# include the configuration file to override any of these variables
# no variable expansions or targets are allowed in these files.
include $(GARDIR)/gar.conf.mk
-include $(addprefix $(GARDIR)/,$(GAR_EXTRA_CONF)) package-api.mk

# Give us color, if defined in gar.conf.mk
ifeq ($(COLOR_GAR),yes)
include $(GARDIR)/gar.color.mk
endif

PKGDIR = $(shell pwd)

####### Default values for variables which remain unconfigured. #######

##### Default image configuration #####


# Default image filesystem structure
prefix      ?= /usr
exec_prefix ?= $(prefix)
bindir      ?= $(exec_prefix)/bin
sbindir     ?= $(exec_prefix)/sbin
libexecdir  ?= $(exec_prefix)/libexec
datadir     ?= $(prefix)/share
sysconfdir  ?= /etc
sharedstatedir ?= $(prefix)/share
localstatedir  ?= /var
libdir         ?= $(exec_prefix)/lib
infodir        ?= $(prefix)/share/info
lispdir        ?= $(prefix)/share/emacs/site-lisp
includedir     ?= $(prefix)/include
mandir         ?= $(prefix)/share/man
docdir         ?= $(prefix)/share/doc/$(DISTNAME)
localedir      ?= $(prefix)/share/locale
sourcedir      ?= $(prefix)/src
licensedir     ?= $(prefix)/licenses
rcdir          ?= /etc/rc.d


# Default DESTDIR
DESTDIR ?= $(PKGDIR)/$(WORKDIR)/destdir

# Default architecture (GARCH and GARHOST).
# Override these for cross-compilation
GARCH ?= $(shell uname -m)
GARHOST ?= $(shell gcc -dumpmachine)

# If not specified, then glibc
LIBC ?= devel/glibc

# Default tools
CC     ?= gcc
CXX    ?= g++
LD     ?= ld
RANLIB ?= ranlib
CPP    ?= $(CC) -E
CPP    ?= cpp
AS     ?= as
AR     ?= ar


##### Set upstream package control variables #####


# Some architectures go by multiple names. GARCH should always be the string
# output by `arch'. ALTGARCH should be set to the other name. In cases where
# there is no altername name, set to GARCH
ALTGARCH = $(GARCH)
ALTGARCH := $(if $(filter $(GARCH),ppc),powerpc,$(ALTGARCH))

# GARTARGET may be exported from a package with an arbitrary value to indicate
# that dependencies of that package which recognize a "target" platform, such
# as GCC and GNU binutils, should target the specified platform.  The default
# value of $(GARHOST) causes the those packages to produce native tools.
GARTARGET ?= $(GARHOST)


####### Defaults for GAR target control variables #######
DISTNAME ?= $(GARNAME)-$(GARVERSION)
FILEDIR ?= files
DOWNLOADDIR ?= download
PARTIALDIR ?= $(DOWNLOADDIR)/partial
COOKIEROOTDIR ?= cookies
COOKIEDIR ?= $(COOKIEROOTDIR)
WORKROOTDIR ?= work
WORKDIR ?= $(WORKROOTDIR)
WORKSRC ?= $(WORKDIR)/$(DISTNAME)
EXTRACTDIR ?= $(WORKDIR)
SCRATCHDIR ?= tmp
CHECKSUM_FILE ?= sha256sums
CHECKSUM_CMD = $(if $(findstring sha256,$(CHECKSUM_FILE)),sha256sum,md5sum)
MANIFEST_FILE ?= manifest
GPG_KEYRING ?= ./gpg-keyring

MANIFEST_FILE ?= manifest
ALLFILES ?= $(DISTFILES) $(PATCHFILES)
STAGINGDIR ?= $(DESTDIR)$(prefix)/staging

####### Useful Macros #######
DIRSTODOTS = $(subst . /,./,$(patsubst %,/..,$(subst /, ,/$(1))))
ROOTFROMDEST = $(call DIRSTODOTS,$(DESTDIR))

# allow us to use programs we just built
#PATH := $(build_DESTDIR)$(build_libdir)/ccache:$(build_DESTDIR)$(build_bindir):$(build_DESTDIR)$(build_sbindir):$(PATH):$(build_DESTDIR)$(build_bindir):$(build_DESTDIR)$(build_sbindir)
# this causes pain for all involved once glibc is built.
#LD_LIBRARY_PATH := /lib:$(DESTDIR)$(libdir):$(build_DESTDIR)$(build_prefix)/lib:/lib:/usr/lib
# or at least it did before we had DESTDIR and fully-munged
# builddeps.  The following may be more of a hindrance than a
# help nowadays:
#LD_PRELOAD +=/lib/libc.so.6

# XXX: BUILD_CLEAN handling should go in lib
ifdef BUILD_CLEAN
DO_BUILD_CLEAN = buildclean
export CCACHE_DISABLE=foo
else
DO_BUILD_CLEAN =
endif

MFLAGS   += -j$(MAKEJOBS)
PARALLELMFLAGS ?= $(MFLAGS)
export PARALLELMFLAGS

#INSTALL_DIRS = $(addprefix $(DESTDIR),$(prefix) $(exec_prefix) $(bindir) $(sbindir) $(libexecdir) $(datadir) $(sysconfdir) $(sharedstatedir) $(localstatedir) $(libdir) $(infodir) $(lispdir) $(includedir) $(mandir) $(foreach NUM,1 2 3 4 5 6 7 8, $(mandir)/man$(NUM)) $(sourcedir))
INSTALL_DIRS += $(IZTACI_PACKAGE_PATH) 

# For rules that do nothing, display what dependencies they
# successfully completed
#DONADA = @echo "	[$@] complete.  Finished rules: $+"
DONADA = @touch $(COOKIEDIR)/$@; echo -e "	$(ANNOUNCECOLOR)[$(STAGECOLOR)$@$(ANNOUNCECOLOR)] complete for $(NAMECOLOR)$(GARNAME)$(ANNOUNCECOLOR).$(NORMALCOLOR)";

# TODO: write a stub rule to print out the name of a rule when it
# *does* do something, and handle indentation intelligently.

# Default sequence for "all" is:  fetch checksum extract patch configure build
all: build
	$(DONADA)


include $(GARDIR)/gar.lib.mk
include $(GARDIR)/gar.bugs.mk

include $(GARDIR)/iztaci.lib.mk
include $(GARDIR)/iztaci-package.mk

#################### DIRECTORY MAKERS ####################

# This is to make dirs as needed by the base rules
$(sort $(DOWNLOADDIR) $(PARTIALDIR) $(COOKIEDIR) $(WORKSRC) $(WORKDIR) $(EXTRACTDIR) $(FILEDIR) $(SCRATCHDIR) $(INSTALL_DIRS) $(GARCHIVEDIR) $(GARPKGDIR) $(PKGARCHIVEDIR) $(STAGINGDIR) $(CONFIG_DIRS)):
	@if test -d $@; then : ; else \
		install -d $@; \
		echo -e "$(WORKCOLOR)making directory $(BOLD)$@$(NORMALCOLOR)"; \
	fi

 $(COOKIEDIR)/%:
	@if test -d $@; then : ; else \
		install -d $@; \
		echo -e "$(WORKCOLOR)making directory $(BOLD)$@$(NORMALCOLOR)"; \
	fi
# These stubs are wildcarded, so that the port maintainer can
# define something like "pre-configure" and it won't conflict,
# while the configure target can call "pre-configure" safely even
# if the port maintainer hasn't defined it.
# 
# in addition to the pre-<target> rules, the maintainer may wish
# to set a "pre-everything" rule, which runs before the first
# actual target.
pre-%:
	@true

post-%:
	@true

custom-%:
	@true

# Call any arbitrary rule recursively
deep-%: %
	@$(foreach IMG,$(IMGDEPS),for dep in $(filter-out $($(IMG)_NODEPEND),$($(IMG)_DEPENDS)); do $(MAKE) -C ../../$$dep $@; done; )

# ========================= MAIN RULES ========================= 
# The main rules are the ones that the user can specify as a
# target on the "make" command-line.  Currently, they are:
#	fetch-list fetch checksum makesum extract checkpatch patch
#	build install reinstall uninstall package
# (some may not be complete yet).
#
# Each of these rules has dependencies that run in the following
# order:
# 	- run the previous main rule in the chain (e.g., install
# 	  depends on build)
#	- run the pre- rule for the target (e.g., configure would
#	  then run pre-configure)
#	- generate a set of files to depend on.  These are typically
#	  cookie files in $(COOKIEDIR), but in the case of fetch are
#	  actual downloaded files in $(DOWNLOADDIR)
# 	- run the post- rule for the target
# 
# The main rules also run the $(DONADA) code, which prints out
# what just happened when all the dependencies are finished.


pkg-info:
	@echo -e "$(ANNOUNCECOLOR)Name:$(NORMALCOLOR)    $(GARNAME)"
	@echo -e "$(ANNOUNCECOLOR)Version:$(NORMALCOLOR) $(GARVERSION)$(if $(PATCHNUM),-$(PATCHNUM))"
	@echo -e "$(ANNOUNCECOLOR)Release:$(NORMALCOLOR) $(GARELEASE)"
	@echo -e "$(ANNOUNCECOLOR)Category:$(NORMALCOLOR) $(firstword $(CATEGORIES))"
	@echo -e "$(ANNOUNCECOLOR)Homepage:$(NORMALCOLOR) $(HOME_URL)"
	@echo -e "$(ANNOUNCECOLOR)Download URL:$(NORMALCOLOR)"
	@$(foreach df,$(DISTFILES),echo -e " $(firstword $(MASTER_SITES))$(df)";)
	@echo -en "$(ANNOUNCECOLOR)Required packages: "
	@echo -e '$(NORMALCOLOR)$(subst $(newline),$(comma) ,$(SLACK_REQUIRED))'
	@echo -e "$(ANNOUNCECOLOR)Package Maintainer:$(NORMALCOLOR) $(MAINTAINER)"
	@echo -e "$(ANNOUNCECOLOR)Description:\n$(NORMALCOLOR) $(DESCRIPTION)"
	@echo -e ' $(if $(BLURB),$(subst ','"'"',$(subst $(newline),\n ,$(BLURB))), )'

pkg-info-curt:
	@echo -e "$(OK)$(lastword $(subst /, ,$(dir $(shell pwd))))/$(MSG2)$(GARNAME) $(NORMALCOLOR)$(GARVERSION)\n"
	@echo -e " $(DESCRIPTION)\n"

pkginfo: pkg-info

# pkg-rec: generate GNU Recutils-friendly package listings. In other words, this 
# output is more easily machine-readable than that of pkg-info
pkg-rec:
	@echo -e "Garname: $(GARNAME)\n"
	@echo -e "Name: $(NAME)\n"
	@echo -e "Upstream_name: $(UPSTREAMNAME)\n"
	@echo -e "Version: $(GARVERSION)\n"
	@echo -e "Home_URL: $(HOME_URL)\n"
	@echo -e "Download_URL: $(firstword $(MASTER_SITES))$(MASTER_SUBDIR)\n"
	@echo -e "Description: $(DESCRIPTION)\n"
	@echo -e 'Blurb: $(subst $(newline),\n+ ,$(BLURB))\n'
	@for i in $(BUILDDEPS); do echo -e "Build_dep: $$i\n"; done
	@for i in $(LIBDEPS); do echo -e "Lib_dep: $$i\n"; done
	@for i in $(TESTDEPS); do echo -e "Test_dep: $$i\n"; done

pkgrec: pkg-rec

announce:
	@echo -e "$(ANNOUNCECOLOR)[===== NOW BUILDING:	$(NAMECOLOR)$(DISTNAME)	$(ANNOUNCECOLOR)=====]$(NORMALCOLOR)"

# fetch-list	- Show list of files that would be retrieved by fetch.
# NOTE: DOES NOT RUN pre-everything!
fetch-list:
	@echo "Distribution files: "
	@for i in $(DISTFILES); do echo "	$$i"; done
	@echo "Patch files: "
	@for i in $(PATCHFILES); do echo "	$$i"; done

# showdeps		- Show dependencies in a tree-structure
showdeps:
	@$(foreach IMG,$(IMGDEPS),for dep in $(filter-out $($(IMG)_NODEPEND),$($(IMG)_DEPENDS)); do echo -e "$(TABLEVEL)$(IMG): $$dep"; $(MAKE) -s -C $(GARDIR)/$$dep TABLEVEL="$(TABLEVEL)\t" showdeps; done ;) true

# fetch			- Retrieves $(DISTFILES) (and $(PATCHFILES) if defined)
#				  into $(DOWNLOADDIR) as necessary.
FETCH_TARGETS =  $(addprefix $(DOWNLOADDIR)/,$(ALLFILES))

fetch: announce pre-everything $(COOKIEDIR) $(DOWNLOADDIR) $(PARTIALDIR) $(addprefix dep-$(GARDIR)/,$(FETCHDEPS)) pre-fetch $(FETCH_TARGETS) post-fetch 
	$(DONADA)

# returns true if fetch has completed successfully, false
# otherwise
fetch-p:
	@$(foreach COOKIEFILE,$(FETCH_TARGETS), test -e $(COOKIEDIR)/$(COOKIEFILE) ;)
# checksum		- Use $(CHECKSUMFILE) to ensure that your
# 				  distfiles are valid.
checksum: fetch pre-checksum custom-pre-checksum $(addprefix checksum-,$(filter-out $(NOCHECKSUM),$(ALLFILES))) post-checksum custom-post-checksum
	$(DONADA)

# returns true if checksum has completed successfully, false
# otherwise
checksum-p:
	$(foreach COOKIEFILE,$(addprefix $(COOKIEDIR)/checksum-,$(filter-out $(NOCHECKSUM),$(ALLFILES))), test -e $(COOKIEFILE) ;)

# makesum		- Generate distinfo (only do this for your own ports!).
makesum: fetch $(addprefix $(DOWNLOADDIR)/,$(filter-out $(NOCHECKSUM),$(ALLFILES))) checksig
	@if test -r $(CHECKSUM_FILE); then \
		echo -e "	[$(WARNCOLOR)makesum$(NORMALCOLOR)] $(NORMALCOLOR)There is already a checksum file ( $(CHECKSUM_FILE) )."; \
		echo -e "	[$(WARNCOLOR)makesum$(NORMALCOLOR)] $(NORMALCOLOR)Delete it first if you want to re-create it."; \
		exit 1; \
	else \
		if test "x$(addprefix $(DOWNLOADDIR)/,$(filter-out $(NOCHECKSUM),$(ALLFILES)))" != "x"; then \
			echo -e " $(WORKCOLOR)==> Running $(CHECKSUM_CMD) on $(BOLD)$(filter-out $(NOCHECKSUM),$(ALLFILES))$(NORMALCOLOR)"; \
			$(CHECKSUM_CMD) $(addprefix $(DOWNLOADDIR)/,$(filter-out $(NOCHECKSUM),$(ALLFILES))) > $(CHECKSUM_FILE); \
		fi \
	fi

# I am always typing this by mistake
makesums: makesum

# checksig      - Use signatures in $(SIGFILES) to check downloaded files.
checksig: fetch $(COOKIEDIR) pre-checksig custom-pre-checksig $(addprefix checksig-,$(SIGFILES)) post-checksig custom-post-checksig
	$(DONADA)

checksig-p:
	$(foreach COOKIEFILE,$(addprefix $(COOKIEDIR)/checksig-,$(SIGFILES)), test -e $(COOKIEFILE) ;)

# garchive      - Copy downloaded files to $(GARCHIVEDIR)
GARCHIVE_TARGETS =  $(addprefix $(GARCHIVEDIR)/,$(ALLFILES))

garchive: checksum $(COOKIEDIR) pre-garchive custom-pre-garchive $(GARCHIVE_TARGETS) post-garchive custom-post-garchive
	$(DONADA)


# extract		- Unpacks $(DISTFILES) into $(EXTRACTDIR) (patches are "zcatted" into the patch program)
EXTRACT_TARGETS = $(addprefix extract-,$(filter-out $(NOEXTRACT),$(DISTFILES)))
EXTRACT_SOURCEPKG = $(addprefix $(COOKIEDIR)/sourcepkg-,$(addsuffix /patch,$(SOURCEPKG)))

extract: checksum $(EXTRACTDIR) $(COOKIEDIR) $(EXTRACT_SOURCEPKG) $(addprefix dep-$(GARDIR)/,$(EXTRACTDEPS)) pre-extract $(EXTRACT_TARGETS) post-extract
	$(DONADA)

# returns true if extract has completed successfully, false
# otherwise
extract-p:
	@$(foreach COOKIEFILE,$(EXTRACT_TARGETS), test -e $(COOKIEDIR)/$(COOKIEFILE) ;)

# checkpatch	- Do a "patch -C" instead of a "patch".  Note
# 				  that it may give incorrect results if multiple
# 				  patches deal with the same file.
# TODO: actually write it!
checkpatch: extract
	@echo -e "$(ERRORCOLOR)$@ NOT IMPLEMENTED YET$(NORMALCOLOR)"

# patch			- Apply any provided patches to the source.
PATCH_TARGETS = $(addprefix garpatch-,$(PATCHFILES))

patch: extract $(WORKSRC) pre-patch $(PATCH_TARGETS) post-patch
	$(DONADA)

# returns true if patch has completed successfully, false
# otherwise
patch-p:
	@$(foreach COOKIEFILE,$(PATCH_TARGETS), test -e $(COOKIEDIR)/$(COOKIEFILE) ;)

# makepatch		- Grab the upstream source and diff against $(WORKSRC).  Since
# 				  diff returns 1 if there are differences, we remove the patch
# 				  file on "success".  Goofy diff.
makepatch: $(SCRATCHDIR) $(FILEDIR) $(FILEDIR)/gar-base.diff
	$(DONADA)

# this takes the changes you've made to a working directory,
# distills them to a patch, updates the checksum file, and tries
# out the build (assuming you've listed the gar-base.diff in your
# PATCHFILES).  This is way undocumented.  -NickM
beaujolais: makepatch makesum clean build
	$(DONADA)

# configure		- Runs either GNU configure, one or more local
# 				  configure scripts or nothing, depending on
# 				  what's available.
CONFIGURE_TARGETS = $(addprefix configure-,$(CONFIGURE_SCRIPTS))
CONFIGURE_IMGDEPS = $(addprefix imgdep-,$(IMGDEPS))

configure: patch $(CONFIGURE_IMGDEPS) $(addprefix srcdep-$(GARDIR)/,$(SOURCEDEPS)) pre-configure $(CONFIGURE_TARGETS) post-configure
	$(DONADA)

# returns true if configure has completed successfully, false
# otherwise
configure-p:
	@$(foreach COOKIEFILE,$(CONFIGURE_TARGETS), test -e $(COOKIEDIR)/$(COOKIEFILE) ;)

# build			- Actually compile the sources.
BUILD_TARGETS = $(addprefix build-,$(BUILD_SCRIPTS))

build: configure pre-build $(BUILD_TARGETS) post-build
	$(DONADA)

# returns true if build has completed successfully, false
# otherwise
build-p:
	@$(foreach COOKIEFILE,$(BUILD_TARGETS), test -e $(COOKIEDIR)/$(COOKIEFILE) ;)

# strip			- Strip binaries
strip: pre-strip do-strip post-strip

# install		- Install the results of a build.
INSTALL_TARGETS = $(addprefix install-,$(INSTALL_SCRIPTS)) 

install: build $(addprefix dep-$(GARDIR)/,$(INSTALLDEPS)) $(INSTALL_DIRS) pre-install $(INSTALL_TARGETS) post-install $(DO_BUILD_CLEAN) $(if $(filter $(USE_STOW),yes),stow)
	$(DONADA)

# returns true if install has completed successfully, false
# otherwise
install-p:
	@$(foreach COOKIEFILE,$(INSTALL_TARGETS), test -e $(COOKIEDIR)/$(COOKIEFILE) ;)

# installstrip		- Install the results of a build, stripping first.
installstrip: strip pre-install $(INSTALL_TARGETS) post-install
	$(DONADA)

# reinstall		- Install the results of a build, ignoring
# 				  "already installed" flag.
reinstall: build
	rm -rf $(COOKIEDIR)/*install*
	$(MAKE) install

# uninstall		- Remove the installation if it was installed
# 					with stow in mind.
uninstall: 
	@$(if $(filter $(USE_STOW),yes),rm -rf $(DESTDIR)$(STOW_PREFIX)/$(GARNAME)-$(GARVERSION),echo -e "$(ERRORCOLOR)$@ only works if you installed with USE_STOW$(NORMALCOLOR)")
	$(DONADA)


# stow			- merge stow-installed packages into the system.
stow: install pre-stow stow-$(DISTNAME) post-stow
	$(DONADA)

unstow: unstow-$(DISTNAME)
	$(DONADA)

# package		- Create a package from an _installed_ port.
package: build install install-$(MANIFEST_FILE) pre-package makepkg post-package
	@cd $(DESTDIR)
	$(DONADA)

# tarball		- Make a tarball from an install of the package into a scratch dir
tarball:

	$(MAKE) install
	$(MAKE)  $*_DESTDIR="$(CURDIR)/$(SCRATCHDIR)" reinstall
	find $(SCRATCHDIR) -depth -type d | while read i; do rmdir $$i > /dev/null 2>&1 || true; done
	tar czvf $(CURDIR)/$(WORKDIR)/$(DISTNAME)-$*-install.tar.gz -C $(SCRATCHDIR) .
	$(MAKECOOKIE)


# pkgarchive	- Copy package to a local package repository, creating the necessary directories
MAIN_CAT=$(firstword $(CATEGORIES))
SEC_CAT=$(wordlist 2,$(words $(CATEGORIES)),$(CATEGORIES))
MAIN_PKGDEST=$(PKGARCHIVEDIR)/$(MAIN_CAT)
PKGDESTS=$(addprefix $(PKGARCHIVEDIR)/, $(CATEGORIES))

pkgarchive: $(IZTACI_PACKAGE_DEST) $(PKGARCHIVEDIR) $(COOKIEDIR) pre-pkgarchive custom-pre-pkggarchive do-pkgarchive post-pkgarchive custom-post-pkgarchive
	$(DONADA)


do-pkgarchive:
	mkdir -vp $(PKGDESTS)
#	$(foreach dst, $(PKGDESTS), cp -av $(IZTACI_PACKAGE_DEST) $(dst); )
	$(foreach dst, $(MAIN_PKGDEST), cp -av $(IZTACI_PACKAGE_DEST) $(dst); )
	$(MAKECOOKIE)

	

# garpkg		- Save a created package to the local package repository
#
# TODO: This could be cleaned up a bit and become a good way to make
#       distributions-neutral tarball when not running on Iztaci.
#
# TODO: Maybe even fully modularize the package building phase to support
#       rpm, deb, arch, etc. a'la checkinstall.
#
#garpkg: package $(GARPKGDIR)
#	$(MAKE) prefix="/usr/local" install
#	$(MAKE) prefix="/usr/local" DESTDIR="$(CURDIR)/$(SCRATCHDIR)" reinstall
#	find $(SCRATCHDIR) -depth -type d | while read i; do rmdir $$i > /dev/null 2>&1 || true; done
#	tar czvf $(CURDIR)/$(WORKDIR)/$(DISTNAME)-install.tar.gz -C $(SCRATCHDIR)/usr/local .
#	install -m 644 -D $(CURDIR)/$(WORKDIR)/$(DISTNAME)-install.tar.gz $(GARPKGDIR)/$(DISTNAME).tar.gz
#	ln -fs $(DISTNAME).tar.gz $(GARPKGDIR)/$(GARNAME).tar.gz
#	rm -f $(GARPKGDIR)/$(GARNAME).tar.gz.sig
#	gpg --detach-sign $(GARPKGDIR)/$(GARNAME).tar.gz
#	mv $(GARPKGDIR)/$(GARNAME).tar.gz.sig $(GARPKGDIR)/$(DISTNAME).tar.gz.sig	
#	ln -fs $(DISTNAME).tar.gz.sig $(GARPKGDIR)/$(GARNAME).tar.gz.sig
#	$(MAKECOOKIE)
	

# The clean rule.  It must be run if you want to re-download a
# file after a successful checksum (or just remove the checksum
# cookie, but that would be lame and unportable).
clean: pre-clean cookieclean post-clean
	@rm -rf $(DOWNLOADDIR)
	@echo -e "  $(ANNOUNCECOLOR)[$(STAGECOLOR)$@$(ANNOUNCECOLOR)] complete for $(NAMECOLOR)$(GARNAME)$(ANNOUNCECOLOR).$(NORMALCOLOR)"

cookieclean: buildclean
	@rm -rf $(COOKIEROOTDIR)

buildclean:
	@rm -rf $(WORKSRC) $(WORKROOTDIR) $(EXTRACTDIR) $(SCRATCHDIR) $(SCRATCHDIR)-$(COOKIEDIR) $(SCRATCHDIR)-build *~

imgclean:
	rm -rf $(DESTDIR)$(prefix)

superclean: clean imgclean

love:
	@echo -e "$(REVERSE) not war! $(NORMALCOLOR)"

# these targets do not have actual corresponding files
.PHONY: all fetch-list beaujolais fetch-p checksum-p extract-p patch-p configure-p build-p install-p love strip do-strip pkgarchive do-pkgarchive gzip-man gzip-info etcnew etc-new usr-to-lib s6rc sysconfig

# apparently this makes all previous rules non-parallelizable,
# but the actual builds of the packages will be, according to
# jdub.
.NOTPARALLEL:
