#
# Copyright (C) 2014 Felipe Eduardo Sanchez Diaz Duran
#
#
# Redistribution and/or use, with or without modification, is
# permitted.  This software is without warranty of any kind.  The
# author(s) shall not be liable in the event that use of the
# software causes damage.
#

SLACK_INSTALL = $(DESTDIR)/install
DOINST_SH = $(SLACK_INSTALL)/doinst.sh
SLACK_DESC = $(SLACK_INSTALL)/slack-desc
SLACK_REQ_FILE = $(SLACK_INSTALL)/slack-required
SLACK_SUG_FILE = $(SLACK_INSTALL)/slack-suggests
SLACK_CON_FILE = $(SLACK_INSTALL)/slack-conflicts

IZTACI_PACKAGE_NAME = $(GARNAME)-$(GARVERSION)-$(GARCH)-$(GARELEASE).tlz
IZTACI_PACKAGE_PATH ?= $(PKGDIR)
IZTACI_PACKAGE_DEST = $(IZTACI_PACKAGE_PATH)/$(IZTACI_PACKAGE_NAME)

IZTACI_PACKAGE_FILES = doinstsh slackdesc slackreq slacksug slackcon

INFODIRS ?= $(infodir)


## Invariants ##
OLDID=`id -u`
OLDGID=`id -g`

## Rules ##
doinstsh: slackinstalldir
		@rm -f $(DOINST_SH)
		@echo -e "$(WORKCOLOR) ==> Creating $(BOLD)doinst.sh$(NORMALCOLOR)"
		@if test "$(CREATE_GROUPS)"; then \
			echo -e "for create_group in $(CREATE_GROUPS); do \n\
				addgroup=\$$(echo \$$create_group | cut -f1 -d:) \n\
				addgid=\$$(echo \$$create_group | cut -f2 -d:) \n\
				gid_opt=\$$([ \"\$$addgid\" ] && echo \"-g \$$addgid\") \n\
				if ! grep -q \"^\$${addgroup}:\" \$$ROOT/etc/group; then \n\
					echo \"Creating group \$$addgroup (\$$addgid)\"\n\
					groupadd -R \$$ROOT/ \$$gid_opt \$$addgroup \n\
				fi \n\
			done" >> $(DOINST_SH); \
		fi
		@if test "$(CREATE_USERS)"; then \
			echo -e "for create_user in $(CREATE_USERS); do \n\
				adduser=\$$(echo \$$create_user | cut -f1 -d:) \n\
				adduid=\$$(echo \$$create_user | cut -f2 -d:) \n\
				addgid=\$$(echo \$$create_user | cut -f3 -d:) \n\
				userhome=\$$(echo \$$create_user | cut -f4 -d:) \n\
				usershell=\$$(echo \$$create_user | cut -f5 -d:) \n\
				un_opt=\$$(if [ \"\$$addgid\" ]; then echo \"-N\"; else echo \"-U\"; fi) \n\
				uid_opt=\$$([ \"\$$adduid\" ] && echo \"-u \$$adduid\") \n\
				gid_opt=\$$([ \"\$$addgid\" ] && echo \"-g \$$addgid\") \n\
				home_opt=\$$(if [ \"\$$userhome\" ]; then echo \"-d \$$userhome\"; else echo \"-d /dev/null\"; fi) \n\
				shell_opt=\$$(if [ \"\$$usershell\" ]; then echo \"-s \$$usershell\"; else echo \"-s /bin/false\"; fi) \n\
				if ! grep -q ^\$${adduser}: \$$ROOT/etc/passwd; then \n\
					echo \"Creating user \$$adduser (\$$adduid)\" \n\
					useradd -R \$$ROOT/ -r \$$un_opt \$$shell_opt \$$home_opt \$$uid_opt \$$gid_opt \$$adduser; \n\
				fi \n\
			done" >> $(DOINST_SH); \
		fi
		@if test "$(CONFDIRS)"; then \
		echo -e "for confdir in $(CONFDIRS); do \n\
			if [ -d \"\$$confdir\" ]; then \n\
			  find \$$ROOT/\$$confdir -name '*.new' | while read i; do \n\
				  BASE=\$$(dirname \"\$$i\")/\$$(basename \"\$$i\" .new) \n\
				  if [ -f \"\$$BASE\" ]; then \n\
				  	rm -f \"\$$i\" \n\
				  else \n\
				  	mv -v \"\$$i\" \"\$$BASE\" \n\
				  fi \n\
			  done; \n\
			fi \n\
done" >> $(DOINST_SH); \
		fi
## info file management ##
# We dont want dir files. We'll update them when installing the package.
		@$(foreach infodir,$(INFODIRS),rm -f -v $(DESTDIR)/$(infodir)/dir;)

# Add install-info commands for every info file found
		$(eval infofiles=$(subst $(DESTDIR)/,,$(wildcard $(DESTDIR)/$(INFODIRS)/*.info*)))
		@if test "$(infofiles)"; then \
		echo -e "if [ -x /usr/bin/install-info ]; then \n \
$(foreach infofile,$(infofiles),\
   /usr/bin/install-info --info-dir \$$ROOT$(dir $(infofile))  \$$ROOT$(infofile) 2>/dev/null\n)\
fi" >> $(DOINST_SH);  \
		fi

# Add the user-defined commands
		@echo -e "$(subst $(newline),\n,$(DOINST_APPEND))" >> $(DOINST_SH)

slackdesc: slackinstalldir
	@rm -f $(SLACK_DESC)
	@echo -e "$(WORKCOLOR) ==> Creating $(BOLD)slack-desc$(NORMALCOLOR)"
	@echo -e "$(GARNAME): $(DESCRIPTION)" >> $(SLACK_DESC)
	@echo -en "$(GARNAME): " >> $(SLACK_DESC)
	@echo -e "$(subst $(newline),\n$(GARNAME): ,$(BLURB))" >> $(SLACK_DESC)
	@echo -e "$(GARNAME):\n" >> $(SLACK_DESC)
	@echo -e "$(GARNAME): Package maintainer: $(MAINTAINER)\n" >> $(SLACK_DESC)
	@echo -e "$(GARNAME):\n" >> $(SLACK_DESC)

slackreq: slackinstalldir
	@rm -f $(SLACK_REQ_FILE)
	@echo -e "$(WORKCOLOR) ==> Creating $(BOLD)$(notdir $(SLACK_REQ_FILE))$(NORMALCOLOR)"
	@echo -e "$(subst $(newline),\n,$(SLACK_REQUIRED))" >> $(SLACK_REQ_FILE)

slacksug: slackinstalldir
	@rm -f $(SLACK_SUG_FILE)
	@echo -e "$(WORKCOLOR) ==> Creating $(BOLD)$(notdir $(SLACK_SUG_FILE))$(NORMALCOLOR)"
	@echo -e "$(subst $(newline),\n,$(SLACK_SUGGESTS))" >> $(SLACK_SUG_FILE)

slackcon: slackinstalldir
	@rm -f $(SLACK_CON_FILE)
	@echo -e "$(WORKCOLOR) ==> Creating $(BOLD)$(notdir $(SLACK_CON_FILE))$(NORMALCOLOR)"
	@echo -e "$(subst $(newline),\n,$(SLACK_CONFLICTS))" >> $(SLACK_CON_FILE)


slackinstalldir: 
	@test -d $(SLACK_INSTALL) || echo -e "$(WORKCOLOR) ==> making directory $(BOLD)$(SLACK_INSTALL)$(NORMALCOLOR)"
	@mkdir -p $(SLACK_INSTALL)


makepkg: doinstsh $(IZTACI_PACKAGE_FILES)
	@if test -x $(MAKEPKG); then :; else echo -e "$(ERRORCOLOR) makepkg is not executable$(NORMALCOLOR)"; exit 1; fi
	@if test -r $(IZTACI_PACKAGE_DEST); then \
	  echo -e "	[$(WARNCOLOR)package$(NORMALCOLOR)] There already is a package file in:"; \
	  echo -e "	[$(WARNCOLOR)package$(NORMALCOLOR)] $(GREEN)$(IZTACI_PACKAGE_DEST)$(NORMALCOLOR)"; \
	  echo -e "	[$(WARNCOLOR)package$(NORMALCOLOR)] Please remove it before continuing."; \
	  exit 1; \
	else \
	  echo -e "	[$(STAGECOLOR)package$(NORMALCOLOR)] $(ANNOUNCECOLOR)We need to su root for this:$(NORMALCOLOR)"; \
	  su -c "echo -e \"$(WORKCOLOR) ==> Changing all permissions to root:root$(NORMALCOLOR)\"; \
	  chown -R root:root $(DESTDIR); \
	  cd $(DESTDIR); \
	  echo -e \"$(WORKCOLOR) ==> Building package$(NORMALCOLOR)\"; \
	  $(MAKEPKG) -l y -c n $(IZTACI_PACKAGE_DEST) || exit 1; \
	  $(RESTORE_OLD_PERMS)"; \
	fi

