## Configuration options for backuppc ##

# Original package info
ORIGVERSION = $(GARVERSION)
ORIGNAME = BackupPC

WORKSRC=$(WORKDIR)/$(ORIGNAME)-$(ORIGVERSION)

BPC_LOGDIR = /var/log/backuppc/server

# Directories which will belong to the backuppc user
BPC_DIRS="/etc/BackupPC /srv/www/backuppc/images /usr/libexec/backuppc/bin $(docdir) /usr/libexec/backuppc/lib/Net/FTP /usr/libexec/backuppc/lib/BackupPC/CGI /usr/libexec/backuppc/lib/BackupPC/Zip /usr/libexec/backuppc/lib/BackupPC/Lang /usr/libexec/backuppc/lib/BackupPC/Xfer /usr/libexec/backuppc/lib/BackupPC/Config /usr/libexec/backuppc/lib/BackupPC/Storage /srv/backuppc /srv/backuppc/pc /srv/backuppc/pool /srv/backuppc/cpool"

# We'll fix the permissions on these directories
FIX_DIRS = /etc

CONFIGURE_OPTS ?= --batch                                     \
                  --dest-dir $(DESTDIR)                       \
                  --backuppc-user=backuppc                    \
                  --cgi-dir /usr/lib/apache2/cgi-bin/backuppc \
                  --data-dir /srv/backuppc                    \
                  --install-dir /usr/libexec/backuppc         \
                  --log-dir $(BPC_LOGDIR)                     \
                  --html-dir /srv/www/backuppc/images         \
                  --html-dir-url /backuppc/images             \
                  --config-override CgiAdminUserGroup=\'backuppc\'  \
                  --config-override CgiAdminUsers=\'bpc-admin\'     \
                  --config-override XferMethod=\'rsyncd\'           \
                  --config-override LogDir=\'$(BPC_LOGDIR)\'        \
                  --config-override RunDir=\'/run/backuppc\'        \
                  --config-override SmbClientPath=\'\'              \
                  --config-override NmbLookupPath=\'\'
BUILD_OPTS ?=
INSTALL_DIRS ?= 
