## Configuration options for mysql ##


MYSQL_DATA_DIR = /srv/mysql

# The version of boost headers required by this MySQL version
BOOST_VERSION=1_69_0

BUILD_DIR=$(WORKDIR)/build


#             -DCMAKE_CXX_FLAGS="$(CFLAGS) -felide-constructors -fno-exceptions -fno-rtti" \

# Most of these come from Slackware's build script for MySQL
CMAKE_OPTS = -B $(PKGDIR)/$(BUILD_DIR) \
             -S $(PKGDIR)/$(WORKSRC)   \
	     -DCMAKE_C_FLAGS="$(CFLAGS)" \
             -DBUILD_CONFIG=mysql_release \
             -DFEATURE_SET="community" \
             -DINSTALL_LAYOUT="RPM" \
             -DCMAKE_INSTALL_PREFIX=$(prefix) \
             -DINSTALL_LIBDIR="lib" \
             -DINSTALL_SBINDIR=libexec \
             -DINSTALL_INCLUDEDIR=include/mysql \
             -DINSTALL_MYSQLSHAREDIR=share/mysql \
             -DINSTALL_SQLBENCHDIR= \
             -DINSTALL_MYSQLTESTDIR=mysql-test \
             -DINSTALL_MANDIR=share/man \
             -DINSTALL_PLUGINDIR="lib/mysql/plugin" \
             -DINSTALL_SCRIPTDIR=bin \
             -DINSTALL_SUPPORTFILESDIR=share/mysql \
             -DINSTALL_MYSQLDATADIR="$(MYSQL_DATA_DIR)" \
             -DINSTALL_DOCREADMEDIR="doc/$(GARNAME)" \
             -DINSTALL_DOCDIR="doc/$(GARNAME)" \
             -DMYSQL_DATADIR="$(MYSQL_DATA_DIR)" \
             -DMYSQL_UNIX_ADDR="/run/mysql/mysql.sock" \
             -DWITH_EXTRA_CHARSETS=complex \
             -DWITH_INNOBASE_STORAGE_ENGINE=1 \
             -DENABLED_LOCAL_INFILE=ON \
             -DWITH_EMBEDDED_SERVER=NO \
             -DWITH_READLINE=ON \
             -DWITH_SSL=system \
             -DWITH_ZLIB=system \
             -DUSE_ARIA_FOR_TMP_TABLES=ON \
             -DWITH_BOOST=$(PKGDIR)/$(WORKDIR)/boost_$(BOOST_VERSION) \
             -DINSTALL_STATIC_LIBRARIES=OFF \
             -DMANUFACTURER="Iztaci" 

#             -DWITH_BOOST_HOME=$(PKGDIR)/$(WORKDIR)/boost_1_69_0 \
CONFIGURE_OPTS ?=
BUILD_OPTS ?=
INSTALL_DIRS ?= 
