## Configuration options for mysql57 ##


MYSQL_DATA_DIR = /srv/mysql57
BUILD_DIR      = $(WORKDIR)/build

# Original package info
ORIGVERSION = $(GARVERSION)
ORIGNAME    = mysql
WORKSRC     = $(WORKDIR)/$(ORIGNAME)-$(ORIGVERSION)

# Most of these come from Slackware's build script for MySQL
CMAKE_OPTS = -B $(PKGDIR)/$(BUILD_DIR) \
             -j $(MAKEJOBS)            \
             -S $(PKGDIR)/$(WORKSRC)   \
             -DBUILD_CONFIG=mysql_release \
             -DFEATURE_SET="community" \
             -DINSTALL_LAYOUT="RPM" \
             -DCMAKE_INSTALL_PREFIX=$(prefix) \
             -DINSTALL_LIBDIR="lib" \
             -DINSTALL_SBINDIR=libexec \
             -DINSTALL_INCLUDEDIR=include/mysql \
             -DINSTALL_MYSQLSHAREDIR=share/mysql \
             -DINSTALL_SQLBENCHDIR= \
             -DINSTALL_MYSQLTESTDIR=mysql-test \
             -DINSTALL_MANDIR=share/man \
             -DINSTALL_PLUGINDIR="lib/mysql/plugin" \
             -DINSTALL_SCRIPTDIR=bin \
             -DINSTALL_SUPPORTFILESDIR=share/mysql \
             -DINSTALL_MYSQLDATADIR="$(MYSQL_DATA_DIR)" \
             -DINSTALL_DOCREADMEDIR="doc/$(DISTNAME)" \
             -DINSTALL_DOCDIR="doc/$(DISTNAME)" \
             -DMYSQL_DATADIR="$(MYSQL_DATA_DIR)" \
             -DMYSQL_UNIX_ADDR="/run/mysql/mysql.sock" \
             -DWITH_EXTRA_CHARSETS=complex \
             -DWITH_INNOBASE_STORAGE_ENGINE=1 \
             -DENABLED_LOCAL_INFILE=ON \
             -DWITH_EMBEDDED_SERVER=NO \
             -DWITH_READLINE=ON \
             -DWITH_SSL=system \
             -DWITH_ZLIB=system \
             -DUSE_ARIA_FOR_TMP_TABLES=ON \
             -DDOWNLOAD_BOOST=1 \
             -DWITH_BOOST="boost/" \
             -DMANUFACTURER="Iztaci" 

BUILD_OPTS ?=
INSTALL_DIRS ?= 

#             -DWITH_BOOST="$(WORKDIR)/work/$(DISTNAME)/boost" \
