## Configuration options for s6-man-pages ##



docdir=/usr/share/doc
mandir=/usr/share/man

CONFIGURE_OPTS ?=
BUILD_OPTS ?=
INSTALL_DIRS ?= 


CURPWD=$$(pwd)

EXECLINE_VERSION        = 2.5.1.0
S6_PORTABLE_UTILS_VERSION = 2.2.1.3
S6_VERSION              = 2.8.0.0
S6_RC_VERSION           = 0.5.0.0
S6_LINUX_UTILS_VERSION  = 2.5.0.1
S6_LINUX_INIT_VERSION   = 0.4.0.1

##### s6 source package files #####

EXECLINE          = execline-$(EXECLINE_VERSION).tar.gz
S6_PORTABLE_UTILS = s6-portable-utils-$(S6_PORTABLE_UTILS_VERSION).tar.gz
S6                = s6-$(S6_VERSION).tar.gz
S6_RC             = s6-rc-$(S6_RC_VERSION).tar.gz
S6_LINUX_UTILS    = s6-linux-utils-$(S6_LINUX_UTILS_VERSION).tar.gz
S6_LINUX_INIT     = s6-linux-init-$(S6_LINUX_INIT_VERSION).tar.gz


##### We will generate man pages for these programs from each s6 package #####

EXECLINE_PROGS = execlineb cd umask emptyenv export unexport fdclose fdblock fdmove fdswap fdreserve redirfd piperw heredoc wait getcwd getpid exec tryexec exit trap withstdinas foreground background if ifelse ifte ifthenelse backtick pipeline runblock define importas elglob elgetpositionals multidefine multisubstitute forx forstdin forbacktickx loopwhilex elgetopt shift dollarat homeof envfile

S6_PORTABLE_UTILS_PROGS = s6-basename s6-cat s6-chmod s6-chown s6-clock s6-cut s6-dirname s6-dumpenv s6-echo s6-env s6-expr s6-false s6-format-filter s6-grep s6-head s6-hiercopy s6-linkname s6-ln s6-ls s6-maximumtime s6-mkdir s6-mkfifo s6-nice s6-nuke s6-pause s6-printenv s6-quote-filter s6-quote s6-rename s6-rmrf s6-seq s6-sleep s6-sort s6-sync s6-tail s6-test s6-touch s6-true s6-uniquename s6-unquote-filter s6-unquote s6-update-symlinks seekablepipe

S6_PROGS = s6-svscan s6-svscanctl s6-supervise s6-svc s6-svok s6-svstat s6-svwait s6-svlisten1 s6-svlisten s6-notifyoncheck s6-svdt s6-svdt-clear s6-permafailon s6-envdir s6-envuidgid s6-fghack s6-setsid s6-setuidgid s6-applyuidgid s6-softlimit s6-tai64n s6-tai64nlocal s6-mkfifodir s6-cleanfifodir s6-ftrig-notify s6-ftrig-wait s6-ftrig-listen1 s6-ftrig-listen s6-ftrigrdinternal s6-ipcclient s6-ipcserver s6-ipcserver-socketbinder s6-ipcserverd s6-ioconnect s6-ipcserver-access s6-connlimit s6-accessrules-cdb-from-fs s6-accessrules-fs-from-cdb s6-sudo s6-sudoc s6-sudod s6-log ucspilogd s6-setlock s6lockd s6lockd-helper s6-fdholder-daemon s6-fdholderd s6-fdholder-store s6-fdholder-storec s6-fdholder-retrieve s6-fdholder-retrievec s6-fdholder-delete s6-fdholder-deletec s6-fdholder-list s6-fdholder-listc s6-fdholder-getdump s6-fdholder-getdumpc s6-fdholder-setdump s6-fdholder-setdumpc s6-fdholder-transferdump s6-fdholder-transferdumpc

S6_RC_PROGS = s6-rc-compile s6-rc-db s6-rc-bundle s6-rc-init s6-rc s6-rc-update s6-rc-format-upgrade s6-rc-dryrun s6-rc-oneshot-run s6-rc-fdholder-filler

S6_LINUX_INIT_PROGS = s6-chroot s6-fillurandompool s6-freeramdisk s6-hostname s6-logwatch s6-mount s6-pivotchroot s6-ps s6-swapoff s6-swapon s6-umount

S6_LINUX_UTILS_PROGS = s6-linux-init-maker s6-halt s6-poweroff s6-reboot

##### Manual section #####

MAN1_PROGS = $(EXECLINE_PROGS) $(S6_PORTABLE_UTILS_PROGS)
MAN8_PROGS = $(S6_PROGS) $(S6_RC_PROGS) $(S6_LINUX_INIT_PROGS) $(S6_LINUX_UTILS_PROGS)


