#!/bin/bash
#
# generate-s6-man-pages
#
# This program expects a list of files in its working directory
# and iterates through the s6_packages variables, reading
# a list of programs from each file and generating a manual page
# from the information in htmldir/$program.html
#
# SYNOPSIS
# generate-s6-man-pages <mandir> <htmldir> <section> <program>...
#

set -e


if [[ $# -lt 4 ]]; then
   echo "Usage: $(basename $0) <mandir> <htmldir> <section> <package>..."
   exit 1
fi

mandir="$1"
htmldir="$2"
section="$3"

shift 2


mkdir -vp "${mandir}/man${section}"

for i in "$@"; do
      htmlfile=$(find "$htmldir" -name "${i}.html" | head -1)
      if [[ -f $htmlfile ]]; then
         keywords=$(grep Keywords "${htmlfile}" | cut -f4 -d\")
         echo "Writing ${mandir}/man${section}/${i}.${section}"
         cat << EOF > ${mandir}/man${section}/${i}.${section}
.TH ${i} ${section}

.SH NAME
${i} \- ${keywords}
.SH DESCRIPTION
This manual page was generated automatically from
.B file:///$(pwd)/${htmlfile}

$(lynx -dump file:///$(pwd)/${htmlfile} | sed 's%file://sk%https://sk%g')
.SH AUTHOR
Laurent Bercot
.SH SEE ALSO
The main ${i} documentation is distributed in HTML form. You can find it online at:

.B "   https://skarnet.org/software"

or browse the locally installed copy at:

.B "   file://${htmlfile}"

EOF
      else
         echo "$htmlfile not found" >&2
      fi
done
