if ! egrep -q "^dspam:" etc/group; then
  echo "Agregando grupo dspam, GID=200"
  groupadd -g 200 dspam
fi

if ! egrep -q "^dspam:" etc/passwd; then
  echo "Agregando usuario dspam, UID=200"
  useradd -s /bin/false -d /dev/null -u 200 -g dspam dspam
fi

echo "Setting owner and permissions for /usr/bin/dspam: dspam.httpd, 6511"
chown dspam.httpd usr/bin/dspam
chmod 6511 $ROOT/usr/bin/dspam

echo "Setting owner and permissions for /usr/bin/dspam_stats: dspam.httpd, 6511"
chown dspam.httpd $ROOT/usr/bin/dspam_stats
chmod 6511 $ROOT/usr/bin/dspam_stats

echo "Setting owner for /var/dspam/{data,log}: dspam.dspam"
chown -R dspam.dspam $ROOT/var/dspam

echo "Setting owner for /var/run/dspam: dspam.dspam"
chown -R dspam.dspam $ROOT/var/run/dspam

chown dspam.dspam $ROOT/etc/dspam.conf

if ! grep -q "##### DSPAM #####" /var/spool/cron/crontabs/root; then

echo "Adding entries for dspam to root's crontab"

cat << EOF >> $ROOT/var/spool/cron/crontabs/root

############### DSPAM ####################

# Eliminar nombres inexistentes del directorio de datos de dspam
*/10 * * * * /usr/sbin/dspam-clean | logger -i -p cron.info -t dspam-clean 2>&1

# Limpiar firmas antiguas de DSPAM
0 3 * * *       find /var/dspam/data -type f  -name "*.sig" -mtime +15 -delete | logger -i -p cron.info -t dspam-clean 2>&1

# Limpiar temporales de dspam-deliver
30 * * * *      find /var/tmp -type f -name "dspam-deliver.*" -mtime +1 -delete &> /dev/null

# Limpieza de BD de DSPAM
45 2 * * *      /usr/sbin/dspam_maintenance.sh --verbose &> /var/log/dspam_maintenance.log

##########################################

EOF

crontab $ROOT/var/spool/cron/crontabs/root

fi

